/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.distributedlock.store;

import java.util.List;
import java.util.Objects;
import org.openingo.jdkits.http.RespData;
import org.openingo.spring.boot.extension.data.redis.RedisTemplateX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class DistributedLockStore
extends RedisTemplateX<String, String> {
    private static final Logger log = LoggerFactory.getLogger(DistributedLockStore.class);

    public DistributedLockStore(StringRedisTemplate stringRedisTemplate) {
        super(stringRedisTemplate);
    }

    public RespData lock(String resource, String lockToken, Integer expireTimeInSecond) {
        try {
            List ret = (List)this.execute(() -> this.setNx(this.key(resource), lockToken, expireTimeInSecond.intValue()));
            return RespData.success((Object)(Objects.nonNull(ret) && (Boolean)ret.get(0) != false ? 1 : 0));
        }
        catch (Throwable throwable) {
            log.error("lock error", throwable);
            return RespData.failure((String)"failure");
        }
    }

    public RespData unlock(String resource, String lockToken) {
        String token = (String)this.get(this.key(resource));
        if (!Objects.equals(token, lockToken)) {
            return RespData.failure((String)"unlock failure");
        }
        try {
            Boolean ret = this.del(this.key(resource));
            if (Objects.nonNull(ret) && ret.booleanValue()) {
                return RespData.success();
            }
            return RespData.failure((String)"unlock failure");
        }
        catch (Throwable throwable) {
            log.error("unlock error", throwable);
            return RespData.failure((String)"unlock failure");
        }
    }

    public RespData extendedLockExpireTime(String resource, String lockToken, Integer expireTimeInSecond) {
        String token = (String)this.get(this.key(resource));
        if (!Objects.equals(token, lockToken)) {
            return RespData.failure((String)"extended lock failure");
        }
        try {
            this.setEx(this.key(resource), expireTimeInSecond.intValue(), lockToken);
            return RespData.success();
        }
        catch (Throwable throwable) {
            log.error("extended lock error", throwable);
            return RespData.failure((String)"extended lock failure");
        }
    }

    private String key(String resource) {
        return String.format("Distributed-Locks:%s", resource);
    }
}

