/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.idempotent.config;

import org.aspectj.lang.ProceedingJoinPoint;
import org.openingo.spring.boot.extension.gedid.config.RedisConnectionConfiguration;
import org.openingo.spring.boot.extension.idempotent.IdempotentAspect;
import org.openingo.spring.boot.extension.idempotent.store.IdempotentStore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@ConditionalOnClass(value={ProceedingJoinPoint.class})
public class IdempotentConfig {
    @Bean
    public IdempotentAspect idempotentAspect(RedisConnectionConfiguration configuration) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(configuration.redisConnectionFactory());
        template.afterPropertiesSet();
        return new IdempotentAspect(new IdempotentStore(template));
    }
}

