/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.data.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openingo.jdkits.collection.ListKit;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.boot.extension.data.redis.callback.SessionCallbackX;
import org.openingo.spring.boot.extension.data.redis.commands.IRedisCommands;
import org.openingo.spring.boot.extension.data.redis.core.DefaultSessionCallback;
import org.openingo.spring.boot.extension.data.redis.naming.IKeyNamingPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.BoundGeoOperations;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.BulkMapper;
import org.springframework.data.redis.core.ClusterOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.HyperLogLogOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.serializer.RedisSerializer;

public class RedisTemplateX<K, V>
implements IRedisCommands<K, V> {
    private RedisTemplate<K, V> redisTemplate;
    @Autowired
    private IKeyNamingPolicy keyNamingPolicy;

    private K namingKey(K key) {
        if (Objects.nonNull(this.keyNamingPolicy) && key instanceof String) {
            return (K)this.keyNamingPolicy.getKeyName(key.toString());
        }
        return key;
    }

    private Collection<K> namingKeys(Collection<K> keys) {
        if (Objects.isNull(this.keyNamingPolicy)) {
            return keys;
        }
        ArrayList converted = new ArrayList();
        keys.forEach(key -> {
            if (key instanceof String) {
                key = this.keyNamingPolicy.getKeyName(key.toString());
            }
            converted.add(key);
        });
        return converted;
    }

    private K[] namingKeys(K ... keys) {
        ArrayList<K> converted = new ArrayList<K>();
        if (Objects.nonNull(keys) && keys.length != 0) {
            for (Object key : keys) {
                if (key instanceof String) {
                    key = this.keyNamingPolicy.getKeyName(key.toString());
                }
                converted.add(key);
            }
        }
        return converted.toArray();
    }

    public RedisTemplateX(RedisTemplate<K, V> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public ClusterOperations<K, V> opsForCluster() {
        return this.redisTemplate.opsForCluster();
    }

    public GeoOperations<K, V> opsForGeo() {
        return this.redisTemplate.opsForGeo();
    }

    public BoundGeoOperations<K, V> boundGeoOps(K key) {
        return this.redisTemplate.boundGeoOps(key);
    }

    public <HK, HV> BoundHashOperations<K, HK, HV> boundHashOps(K key) {
        return this.redisTemplate.boundHashOps(key);
    }

    public <HK, HV> HashOperations<K, HK, HV> opsForHash() {
        return this.redisTemplate.opsForHash();
    }

    public HyperLogLogOperations<K, V> opsForHyperLogLog() {
        return this.redisTemplate.opsForHyperLogLog();
    }

    public ListOperations<K, V> opsForList() {
        return this.redisTemplate.opsForList();
    }

    public BoundListOperations<K, V> boundListOps(K key) {
        return this.redisTemplate.boundListOps(key);
    }

    public BoundSetOperations<K, V> boundSetOps(K key) {
        return this.redisTemplate.boundSetOps(key);
    }

    public SetOperations<K, V> opsForSet() {
        return this.redisTemplate.opsForSet();
    }

    public BoundValueOperations<K, V> boundValueOps(K key) {
        return this.redisTemplate.boundValueOps(key);
    }

    public ValueOperations<K, V> opsForValue() {
        return this.redisTemplate.opsForValue();
    }

    public BoundZSetOperations<K, V> boundZSetOps(K key) {
        return this.redisTemplate.boundZSetOps(key);
    }

    public ZSetOperations<K, V> opsForZSet() {
        return this.redisTemplate.opsForZSet();
    }

    public RedisTemplate<K, V> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setEnableTransactionSupport(Boolean enableTransactionSupport) {
        this.redisTemplate.setEnableTransactionSupport(enableTransactionSupport.booleanValue());
    }

    @Override
    public void set(K key, V value) {
        this.opsForValue().set(this.namingKey(key), value);
    }

    @Override
    public void setEx(K key, long timeoutSeconds, V value) {
        this.opsForValue().set(this.namingKey(key), value, timeoutSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void setEx(K key, long timeout, V value, TimeUnit unit) {
        this.opsForValue().set(this.namingKey(key), value, timeout, unit);
    }

    @Override
    public Boolean setNx(K key, V value) {
        return this.opsForValue().setIfAbsent(this.namingKey(key), value);
    }

    @Override
    public Boolean setNx(K key, V value, long timeoutSeconds) {
        return this.opsForValue().setIfAbsent(this.namingKey(key), value, timeoutSeconds, TimeUnit.SECONDS);
    }

    @Override
    public Boolean setNx(K key, V value, long timeout, TimeUnit unit) {
        return this.opsForValue().setIfAbsent(this.namingKey(key), value, timeout, unit);
    }

    @Override
    public Boolean setXx(K key, V value) {
        return this.opsForValue().setIfPresent(this.namingKey(key), value);
    }

    @Override
    public Boolean setXx(K key, V value, long timeoutSeconds) {
        return this.opsForValue().setIfPresent(this.namingKey(key), value, timeoutSeconds, TimeUnit.SECONDS);
    }

    @Override
    public Boolean setXx(K key, V value, long timeout, TimeUnit unit) {
        return this.opsForValue().setIfPresent(this.namingKey(key), value, timeout, unit);
    }

    @Override
    public V get(K key) {
        return (V)this.opsForValue().get(this.namingKey(key));
    }

    @Override
    public Boolean del(K key) {
        return this.opsForValue().getOperations().delete(this.namingKey(key));
    }

    @Override
    public Long del(Collection<K> keys) {
        return this.opsForValue().getOperations().delete(this.namingKeys(keys));
    }

    @Override
    public void mSet(Object ... keysValues) {
        int length = keysValues.length;
        if (length % 2 != 0) {
            throw new IllegalArgumentException("wrong number of arguments for met, keysValues length can not be odd");
        }
        List keys = ListKit.emptyArrayList((int)(length / 2));
        List values = ListKit.emptyArrayList((int)(length / 2));
        for (int i = 0; i < length; ++i) {
            if (i % 2 == 0) {
                keys.add(keysValues[i]);
                continue;
            }
            values.add(keysValues[i]);
        }
        HashMap keysValuesMap = new HashMap(length);
        for (int i = 0; i < keys.size(); ++i) {
            keysValuesMap.put(this.namingKey(keys.get(i)), values.get(i));
        }
        this.opsForValue().multiSet(keysValuesMap);
    }

    @Override
    public void mSet(Map<K, V> map) {
        HashMap convertedMap = new HashMap();
        map.keySet().forEach(key -> convertedMap.put(this.namingKey(key), map.get(key)));
        this.opsForValue().multiSet(convertedMap);
    }

    @Override
    public List<V> mGet(Collection<K> keys) {
        return this.opsForValue().multiGet(this.namingKeys(keys));
    }

    @Override
    public Long decr(K key) {
        return this.opsForValue().decrement(this.namingKey(key));
    }

    @Override
    public Long decrBy(K key, long delta) {
        return this.opsForValue().decrement(this.namingKey(key), delta);
    }

    @Override
    public Long incr(K key) {
        return this.opsForValue().increment(this.namingKey(key));
    }

    @Override
    public Long incrBy(K key, long delta) {
        return this.opsForValue().increment(this.namingKey(key), delta);
    }

    @Override
    public Boolean exists(K key) {
        return this.opsForValue().getOperations().hasKey(this.namingKey(key));
    }

    @Override
    public void rename(K oldKey, K newKey) {
        this.opsForValue().getOperations().rename(this.namingKey(oldKey), this.namingKey(newKey));
    }

    @Override
    public Boolean expire(K key, long timeoutSeconds) {
        return this.opsForValue().getOperations().expire(this.namingKey(key), timeoutSeconds, TimeUnit.SECONDS);
    }

    @Override
    public Boolean expireAt(K key, Date date) {
        return this.opsForValue().getOperations().expireAt(this.namingKey(key), date);
    }

    @Override
    public Boolean pExpire(K key, long millTimeoutSeconds) {
        return this.opsForValue().getOperations().expire(this.namingKey(key), millTimeoutSeconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public V getSet(K key, V value) {
        return (V)this.opsForValue().getAndSet(this.namingKey(key), value);
    }

    @Override
    public Boolean persist(K key) {
        return this.opsForValue().getOperations().persist(this.namingKey(key));
    }

    @Override
    public DataType type(K key) {
        return this.opsForValue().getOperations().type(this.namingKey(key));
    }

    @Override
    public Long ttl(K key) {
        return this.opsForValue().getOperations().getExpire(this.namingKey(key));
    }

    @Override
    public Long countExistingKeys(Collection<K> keys) {
        return this.opsForValue().getOperations().countExistingKeys(this.namingKeys(keys));
    }

    @Override
    public Integer append(K key, String value) {
        return this.opsForValue().append(this.namingKey(key), value);
    }

    @Override
    public String getRange(K key, long start, long end) {
        return this.opsForValue().get(this.namingKey(key), start, end);
    }

    @Override
    public void setRange(K key, V value, long offset) {
        this.opsForValue().set(this.namingKey(key), value, offset);
    }

    @Override
    public Long strLen(K key) {
        return this.opsForValue().size(this.namingKey(key));
    }

    @Override
    public Boolean setBit(K key, long offset, boolean value) {
        return this.opsForValue().setBit(this.namingKey(key), offset, value);
    }

    @Override
    public Boolean getBit(K key, long offset) {
        return this.opsForValue().getBit(this.namingKey(key), offset);
    }

    @Override
    public List<Long> bitField(K key, BitFieldSubCommands subCommands) {
        return this.opsForValue().bitField(this.namingKey(key), subCommands);
    }

    @Override
    public void hSet(K key, Object hashKey, Object value) {
        this.opsForHash().put(this.namingKey(key), hashKey, value);
    }

    @Override
    public void hmset(K key, Map<Object, Object> m) {
        this.opsForHash().putAll(this.namingKey(key), m);
    }

    @Override
    public <T> T hGet(K key, Object hashKey) {
        return (T)this.opsForHash().get(this.namingKey(key), hashKey);
    }

    @Override
    public <T> List<T> hMget(K key, Collection<Object> hashKeys) {
        return new ArrayList(this.opsForHash().multiGet(this.namingKey(key), hashKeys));
    }

    @Override
    public Long hDel(K key, Object ... hashKeys) {
        return this.opsForHash().delete(this.namingKey(key), hashKeys);
    }

    @Override
    public Boolean hExists(K key, Object hashKey) {
        return this.opsForHash().hasKey(this.namingKey(key), hashKey);
    }

    @Override
    public <HK, HV> Map<HK, HV> hGetAll(K key) {
        return new HashMap(this.opsForHash().entries(this.namingKey(key)));
    }

    @Override
    public <HV> List<HV> hVals(K key) {
        return new ArrayList(this.opsForHash().values(this.namingKey(key)));
    }

    @Override
    public <HK> Set<HK> hKeys(K key) {
        return new HashSet(this.opsForHash().keys(this.namingKey(key)));
    }

    @Override
    public Long hLen(K key) {
        return this.opsForHash().size(this.namingKey(key));
    }

    @Override
    public V lIndex(K key, long index) {
        return (V)this.opsForList().index(this.namingKey(key), index);
    }

    @Override
    public Long lLen(K key) {
        return this.opsForList().size(this.namingKey(key));
    }

    @Override
    public V lPop(K key) {
        return (V)this.opsForList().leftPop(this.namingKey(key));
    }

    @Override
    public Long lPush(K key, V value) {
        return this.opsForList().leftPush(this.namingKey(key), value);
    }

    @Override
    public Long lPush(K key, V ... values) {
        return this.opsForList().leftPushAll(this.namingKey(key), (Object[])values);
    }

    @Override
    public Long lPush(K key, Collection<V> values) {
        return this.opsForList().leftPushAll(this.namingKey(key), values);
    }

    @Override
    public Long lPushx(K key, V value) {
        return this.opsForList().leftPushIfPresent(this.namingKey(key), value);
    }

    @Override
    public void lSet(K key, long index, V value) {
        this.opsForList().set(this.namingKey(key), index, value);
    }

    @Override
    public Long lRem(K key, long count, V value) {
        return this.opsForList().remove(this.namingKey(key), count, value);
    }

    @Override
    public List<V> lRange(K key, long start, long end) {
        return this.opsForList().range(this.namingKey(key), start, end);
    }

    @Override
    public void ltrim(K key, long start, long end) {
        this.opsForList().trim(this.namingKey(key), start, end);
    }

    @Override
    public V rPop(K key) {
        return (V)this.opsForList().rightPop(this.namingKey(key));
    }

    @Override
    public V rPoplPush(K srcKey, K dstKey) {
        return (V)this.opsForList().rightPopAndLeftPush(this.namingKey(srcKey), this.namingKey(dstKey));
    }

    @Override
    public V brPoplPush(K srcKey, K dstKey, long timeoutSeconds) {
        return (V)this.opsForList().rightPopAndLeftPush(this.namingKey(srcKey), this.namingKey(dstKey), timeoutSeconds, TimeUnit.SECONDS);
    }

    @Override
    public Long rPush(K key, V value) {
        return this.opsForList().rightPush(this.namingKey(key), value);
    }

    @Override
    public Long rPush(K key, V ... values) {
        return this.opsForList().rightPushAll(this.namingKey(key), (Object[])values);
    }

    @Override
    public Long rPush(K key, Collection<V> values) {
        return this.opsForList().rightPushAll(this.namingKey(key), values);
    }

    @Override
    public Long rPushx(K key, V value) {
        return this.opsForList().rightPushIfPresent(this.namingKey(key), value);
    }

    @Override
    public V blPop(K key, long timeoutSeconds) {
        return (V)this.opsForList().leftPop(this.namingKey(key), timeoutSeconds, TimeUnit.SECONDS);
    }

    @Override
    public V brPop(K key, long timeoutSeconds) {
        return (V)this.opsForList().rightPop(this.namingKey(key), timeoutSeconds, TimeUnit.SECONDS);
    }

    @Override
    public Long sAdd(K key, V ... values) {
        return this.opsForSet().add(this.namingKey(key), (Object[])values);
    }

    @Override
    public Long sCard(K key) {
        return this.opsForSet().size(this.namingKey(key));
    }

    @Override
    public V sPop(K key) {
        return (V)this.opsForSet().pop(this.namingKey(key));
    }

    @Override
    public Set<V> sMembers(K key) {
        return this.opsForSet().members(this.namingKey(key));
    }

    @Override
    public Boolean sIsMember(K key, Object member) {
        return this.opsForSet().isMember(this.namingKey(key), member);
    }

    @Override
    public Set<V> sInter(K key, K otherKey) {
        return this.opsForSet().intersect(this.namingKey(key), this.namingKey(otherKey));
    }

    @Override
    public Set<V> sInter(K key, Collection<K> otherKeys) {
        return this.opsForSet().intersect(this.namingKey(key), this.namingKeys(otherKeys));
    }

    @Override
    public Long sInterstore(K key, K otherKey, K destKey) {
        return this.opsForSet().intersectAndStore(this.namingKey(key), this.namingKey(otherKey), this.namingKey(destKey));
    }

    @Override
    public Long sInterStore(K key, Collection<K> otherKeys, K destKey) {
        return this.opsForSet().intersectAndStore(this.namingKey(key), this.namingKeys(otherKeys), this.namingKey(destKey));
    }

    @Override
    public V sRandMember(K key) {
        return (V)this.opsForSet().randomMember(this.namingKey(key));
    }

    @Override
    public List<V> sRandMember(K key, long count) {
        return this.opsForSet().randomMembers(this.namingKey(key), count);
    }

    @Override
    public Long sRem(K key, Object ... members) {
        return this.opsForSet().remove(this.namingKey(key), members);
    }

    @Override
    public Set<V> sUnion(K key, K otherKey) {
        return this.opsForSet().union(this.namingKey(key), this.namingKey(otherKey));
    }

    @Override
    public Set<V> sUnion(K key, Collection<K> otherKeys) {
        return this.opsForSet().union(this.namingKey(key), this.namingKeys(otherKeys));
    }

    @Override
    public Long sUnionStore(K key, K otherKey, K destKey) {
        return this.opsForSet().unionAndStore(this.namingKey(key), this.namingKey(otherKey), this.namingKey(destKey));
    }

    @Override
    public Long sUnionStore(K key, Collection<K> otherKeys, K destKey) {
        return this.opsForSet().unionAndStore(this.namingKey(key), this.namingKeys(otherKeys), this.namingKey(destKey));
    }

    @Override
    public Set<V> sDiff(K key, K otherKey) {
        return this.opsForSet().difference(this.namingKey(key), this.namingKey(otherKey));
    }

    @Override
    public Set<V> sDiff(K key, Collection<K> otherKeys) {
        return this.opsForSet().difference(this.namingKey(key), this.namingKeys(otherKeys));
    }

    @Override
    public Long sDiffStore(K key, K otherKey, K destKey) {
        return this.opsForSet().differenceAndStore(this.namingKey(key), this.namingKey(otherKey), this.namingKey(destKey));
    }

    @Override
    public Long sDiffStore(K key, Collection<K> otherKeys, K destKey) {
        return this.opsForSet().differenceAndStore(this.namingKey(key), this.namingKeys(otherKeys), this.namingKey(destKey));
    }

    @Override
    public Boolean zAdd(K key, V member, double score) {
        return this.opsForZSet().add(this.namingKey(key), member, score);
    }

    @Override
    public Long zAdd(K key, Map<V, Double> scoreMembers) {
        if (ValidateKit.isNull(scoreMembers)) {
            return 0L;
        }
        HashSet tuples = new HashSet();
        scoreMembers.forEach((k, score) -> tuples.add(new DefaultTypedTuple(k, score)));
        return this.opsForZSet().add(this.namingKey(key), tuples);
    }

    @Override
    public Long zCard(K key) {
        return this.opsForZSet().size(this.namingKey(key));
    }

    @Override
    public Long zCount(K key, double min, double max) {
        return this.opsForZSet().count(this.namingKey(key), min, max);
    }

    @Override
    public Double zIncrby(K key, V member, double score) {
        return this.opsForZSet().incrementScore(this.namingKey(key), member, score);
    }

    @Override
    public Set<V> zRange(K key, long start, long end) {
        return this.opsForZSet().range(this.namingKey(key), start, end);
    }

    @Override
    public Set<V> zRevRange(K key, long start, long end) {
        return this.opsForZSet().reverseRange(this.namingKey(key), start, end);
    }

    @Override
    public Set<V> zRangeByScore(K key, double min, double max) {
        return this.opsForZSet().rangeByScore(this.namingKey(key), min, max);
    }

    @Override
    public Long zRank(K key, Object member) {
        return this.opsForZSet().rank(this.namingKey(key), member);
    }

    @Override
    public Long zRevRank(K key, Object member) {
        return this.opsForZSet().reverseRank(this.namingKey(key), member);
    }

    @Override
    public Long zRem(K key, Object ... members) {
        return this.opsForZSet().remove(this.namingKey(key), members);
    }

    @Override
    public Double zScore(K key, Object member) {
        return this.opsForZSet().score(this.namingKey(key), member);
    }

    @Override
    public Set<V> zRangeByScore(K key, double min, double max, long offset, long count) {
        return this.opsForZSet().rangeByScore(this.namingKey(key), min, max, offset, count);
    }

    @Override
    public Set<V> zRevRange(K key, double min, double max) {
        return this.opsForZSet().reverseRangeByScore(this.namingKey(key), min, max);
    }

    @Override
    public Set<V> zRevRangeByScore(K key, double min, double max, long offset, long count) {
        return this.opsForZSet().reverseRangeByScore(this.namingKey(key), min, max, offset, count);
    }

    @Override
    public Long zRemRangeByRank(K key, long start, long end) {
        return this.opsForZSet().removeRange(this.namingKey(key), start, end);
    }

    @Override
    public Long zRemRangeByScore(K key, double min, double max) {
        return this.opsForZSet().removeRangeByScore(this.namingKey(key), min, max);
    }

    @Override
    public Long zUnionStore(K key, K otherKey, K destKey) {
        return this.opsForZSet().unionAndStore(this.namingKey(key), this.namingKey(otherKey), this.namingKey(destKey));
    }

    @Override
    public Long zUnionStore(K key, Collection<K> otherKeys, K destKey) {
        return this.opsForZSet().unionAndStore(this.namingKey(key), this.namingKeys(otherKeys), this.namingKey(destKey));
    }

    @Override
    public Long zUnionStore(K key, Collection<K> otherKeys, K destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        return this.opsForZSet().unionAndStore(this.namingKey(key), this.namingKeys(otherKeys), this.namingKey(destKey), aggregate, weights);
    }

    @Override
    public Long zInterStore(K key, K otherKey, K destKey) {
        return this.opsForZSet().intersectAndStore(this.namingKey(key), this.namingKey(otherKey), this.namingKey(destKey));
    }

    @Override
    public Long zInterStore(K key, Collection<K> otherKeys, K destKey) {
        return this.opsForZSet().intersectAndStore(this.namingKey(key), this.namingKeys(otherKeys), this.namingKey(destKey));
    }

    @Override
    public Long zInterStore(K key, Collection<K> otherKeys, K destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        return this.opsForZSet().intersectAndStore(this.namingKey(key), this.namingKeys(otherKeys), this.namingKey(destKey), aggregate, weights);
    }

    @Override
    public Cursor<ZSetOperations.TypedTuple<V>> zScan(K key, ScanOptions options) {
        return this.opsForZSet().scan(this.namingKey(key), options);
    }

    @Override
    public Set<V> zRangeByLex(K key, RedisZSetCommands.Range range) {
        return this.opsForZSet().rangeByLex(this.namingKey(key), range);
    }

    @Override
    public Set<V> zRangeByLex(K key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return this.opsForZSet().rangeByLex(this.namingKey(key), range, limit);
    }

    @Override
    public Long geoAdd(K key, Point point, V member) {
        return this.opsForGeo().add(this.namingKey(key), point, member);
    }

    @Override
    public Long geoAdd(K key, RedisGeoCommands.GeoLocation<V> location) {
        return this.opsForGeo().add(this.namingKey(key), location);
    }

    @Override
    public Long geoAdd(K key, Map<V, Point> memberCoordinateMap) {
        return this.opsForGeo().add(this.namingKey(key), memberCoordinateMap);
    }

    @Override
    public Long geoAdd(K key, Iterable<RedisGeoCommands.GeoLocation<V>> geoLocations) {
        return this.opsForGeo().add(this.namingKey(key), geoLocations);
    }

    @Override
    public Distance geoDist(K key, V member1, V member2) {
        return this.opsForGeo().distance(this.namingKey(key), member1, member2);
    }

    @Override
    public Distance geoDist(K key, V member1, V member2, Metric metric) {
        return this.opsForGeo().distance(this.namingKey(key), member1, member2, metric);
    }

    @Override
    public List<String> geoHash(K key, V ... members) {
        return this.opsForGeo().hash(this.namingKey(key), (Object[])members);
    }

    @Override
    public List<Point> geoPos(K key, V ... members) {
        return this.opsForGeo().position(this.namingKey(key), (Object[])members);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<V>> geoRadius(K key, Circle within) {
        return this.opsForGeo().radius(this.namingKey(key), within);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<V>> geoRadius(K key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.opsForGeo().radius(this.namingKey(key), within, args);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<V>> geoRadiusByMember(K key, V member, double radius) {
        return this.opsForGeo().radius(this.namingKey(key), member, radius);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<V>> geoRadiusByMember(K key, V member, Distance distance) {
        return this.opsForGeo().radius(this.namingKey(key), member, distance);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<V>> geoRadiusByMember(K key, V member, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.opsForGeo().radius(this.namingKey(key), member, distance, args);
    }

    @Override
    public Long geoRemove(K key, V ... members) {
        return this.opsForGeo().remove(this.namingKey(key), (Object[])members);
    }

    @Override
    public Long pfAdd(K key, V ... values) {
        return this.opsForHyperLogLog().add(this.namingKey(key), (Object[])values);
    }

    @Override
    public Long pfCount(K ... keys) {
        return this.opsForHyperLogLog().size((Object[])this.namingKeys(keys));
    }

    @Override
    public Long pfMerge(K destination, K ... sourceKeys) {
        return this.opsForHyperLogLog().union(this.namingKey(destination), (Object[])this.namingKeys(sourceKeys));
    }

    @Override
    public Boolean unlink(K key) {
        return this.redisTemplate.unlink(this.namingKey(key));
    }

    @Override
    public Long unlink(Collection<K> keys) {
        return this.redisTemplate.unlink(this.namingKeys(keys));
    }

    @Override
    public Boolean move(K key, int dbIndex) {
        return this.redisTemplate.move(this.namingKey(key), dbIndex);
    }

    @Override
    public List<V> sort(SortQuery<K> query) {
        return this.redisTemplate.sort(query);
    }

    @Override
    public <T> List<T> sort(SortQuery<K> query, RedisSerializer<T> resultSerializer) {
        return this.redisTemplate.sort(query, resultSerializer);
    }

    @Override
    public <T> List<T> sort(SortQuery<K> query, BulkMapper<T, V> bulkMapper) {
        return this.redisTemplate.sort(query, bulkMapper);
    }

    @Override
    public <T, S> List<T> sort(SortQuery<K> query, BulkMapper<T, S> bulkMapper, RedisSerializer<S> resultSerializer) {
        return this.redisTemplate.sort(query, bulkMapper, resultSerializer);
    }

    @Override
    public Long sort(SortQuery<K> query, K storeKey) {
        return this.redisTemplate.sort(query, storeKey);
    }

    @Override
    public <T> T execute(SessionCallbackX<T> session) {
        DefaultSessionCallback<T> defaultSessionCallback = new DefaultSessionCallback<T>(session);
        return (T)this.redisTemplate.execute(defaultSessionCallback);
    }

    @Override
    public List<Object> executePipelined(SessionCallbackX<?> session) {
        DefaultSessionCallback defaultSessionCallback = new DefaultSessionCallback(session);
        return this.redisTemplate.executePipelined(defaultSessionCallback);
    }

    @Override
    public List<Object> executePipelined(SessionCallbackX session, RedisSerializer<?> resultSerializer) {
        DefaultSessionCallback defaultSessionCallback = new DefaultSessionCallback(session);
        return this.redisTemplate.executePipelined(defaultSessionCallback, resultSerializer);
    }

    @Override
    public void watch(K key) {
        this.redisTemplate.watch(key);
    }

    @Override
    public void watch(Collection<K> keys) {
        this.redisTemplate.watch(keys);
    }

    @Override
    public void unwatch() {
        this.redisTemplate.unwatch();
    }

    @Override
    public void multi() {
        this.redisTemplate.multi();
    }

    @Override
    public void discard() {
        this.redisTemplate.discard();
    }

    @Override
    public List<Object> exec() {
        return this.redisTemplate.exec();
    }

    @Override
    public List<Object> exec(RedisSerializer<?> valueSerializer) {
        return this.redisTemplate.exec(valueSerializer);
    }
}

