/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.distributedlock.lock;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import org.openingo.jdkits.http.RespData;
import org.openingo.jdkits.sys.SystemClockKit;
import org.openingo.spring.boot.extension.distributedlock.config.DistributedLockConfig;
import org.openingo.spring.boot.extension.distributedlock.lock.DistributedLockOwner;
import org.openingo.spring.boot.extension.distributedlock.lock.DistributedLockPingPong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DistributedLock
implements Lock {
    private static final Logger log = LoggerFactory.getLogger(DistributedLock.class);
    private String lockToken;
    private final String resource;
    private final boolean reentrant;
    private static final Integer LOCK_DEADLINE = 200;

    private DistributedLock(String resource, boolean reentrant) {
        this.resource = resource;
        this.reentrant = reentrant;
    }

    public static Lock newLock(String resource) {
        return new DistributedLock(resource, true);
    }

    public static Lock newLock(String resource, boolean reentrant) {
        return new DistributedLock(resource, reentrant);
    }

    @Override
    public void lock() {
        boolean locked = this.tryLock();
        Assert.isTrue((boolean)locked, (String)"get lock failure, try again later");
    }

    @Override
    @Deprecated
    public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryLock() {
        boolean needUpdate;
        if (Objects.nonNull(this.lockToken)) {
            return false;
        }
        String token = UUID.randomUUID().toString();
        RespData respData = DistributedLockPingPong.DISTRIBUTED_LOCK_STORE.lock(this.resource, token, DistributedLockConfig.EXPIRE_SECONDS);
        boolean succeed = respData.succeed();
        if (succeed && Boolean.TRUE.equals(respData.getData())) {
            this.addLock(token);
            return true;
        }
        boolean bl = needUpdate = succeed && Boolean.FALSE.equals(respData.getData()) && this.reentrant && this.isSameThread();
        if (needUpdate) {
            this.updateLock();
            return true;
        }
        return false;
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        Assert.isTrue((unit.toMillis(time) <= 300000L ? 1 : 0) != 0, (String)"Too many attempts, just max try 300000 millis");
        long tryingLockTime = SystemClockKit.now() + unit.toMillis(time);
        log.info("trying lock time {}", (Object)tryingLockTime);
        while (SystemClockKit.now() < tryingLockTime) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.tryLock()) {
                return true;
            }
            LockSupport.parkUntil(this, SystemClockKit.now() + (long)LOCK_DEADLINE.intValue());
        }
        return false;
    }

    @Override
    public void unlock() {
        DistributedLockOwner lockOwner = DistributedLockPingPong.DISTRIBUTED_LOCK_OWNERS.get(this.resource);
        if (lockOwner != null && lockOwner.getLockToken().equals(this.lockToken)) {
            lockOwner.reference(-1);
            this.lockToken = null;
            if (lockOwner.getLockedCount() <= 0) {
                DistributedLockPingPong.DISTRIBUTED_LOCK_OWNERS.remove(this.resource);
                RespData respData = DistributedLockPingPong.DISTRIBUTED_LOCK_STORE.unlock(this.resource, lockOwner.getLockToken());
                if (!respData.succeed()) {
                    log.info("unlock failed resource {}", (Object)this.resource);
                }
            }
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    private boolean isSameThread() {
        DistributedLockOwner lockOwner = DistributedLockPingPong.DISTRIBUTED_LOCK_OWNERS.get(this.resource);
        return Objects.nonNull(lockOwner) && lockOwner.getThread() == Thread.currentThread();
    }

    private void addLock(String lockToken) {
        this.lockToken = lockToken;
        DistributedLockOwner lockOwner = DistributedLockOwner.builder().thread(Thread.currentThread()).lockedCount(1).lockToken(lockToken).lastPingPongTimeMillis(SystemClockKit.now()).build();
        DistributedLockPingPong.DISTRIBUTED_LOCK_OWNERS.put(this.resource, lockOwner);
    }

    private void updateLock() {
        DistributedLockOwner lockOwner = DistributedLockPingPong.DISTRIBUTED_LOCK_OWNERS.get(this.resource);
        if (Objects.nonNull(lockOwner)) {
            this.lockToken = lockOwner.getLockToken();
            lockOwner.reference(1);
        }
    }
}

