/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.distributedlock.lock;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;
import org.openingo.jdkits.http.RespData;
import org.openingo.jdkits.sys.SystemClockKit;
import org.openingo.spring.boot.extension.distributedlock.config.DistributedLockConfig;
import org.openingo.spring.boot.extension.distributedlock.lock.DistributedLockOwner;
import org.openingo.spring.boot.extension.distributedlock.store.DistributedLockStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLockPingPong {
    private static final Logger log = LoggerFactory.getLogger(DistributedLockPingPong.class);
    static Map<String, DistributedLockOwner> DISTRIBUTED_LOCK_OWNERS = new ConcurrentHashMap<String, DistributedLockOwner>();
    static DistributedLockStore DISTRIBUTED_LOCK_STORE;
    private static final Long PING_PONG_DEADLINE;

    public static void start(DistributedLockStore distributedLockStore) {
        if (Objects.isNull(DISTRIBUTED_LOCK_STORE)) {
            DISTRIBUTED_LOCK_STORE = distributedLockStore;
        }
        Thread pingPong = new Thread(){

            @Override
            public void run() {
                log.info("lock ping pong thread running...");
                while (true) {
                    try {
                        block3: while (true) {
                            LockSupport.parkUntil(SystemClockKit.now() + PING_PONG_DEADLINE);
                            for (Map.Entry<String, DistributedLockOwner> entry : DISTRIBUTED_LOCK_OWNERS.entrySet()) {
                                RespData respData = DISTRIBUTED_LOCK_STORE.extendedLockExpireTime(entry.getKey(), entry.getValue().getLockToken(), DistributedLockConfig.EXPIRE_SECONDS);
                                log.info("DistributedReentrantLock extendedLockExpireTime {}", (Object)respData);
                                if (!respData.succeed()) continue;
                                entry.getValue().setLastPingPongTimeMillis(SystemClockKit.now());
                            }
                            Iterator<Map.Entry<String, DistributedLockOwner>> iterator = DISTRIBUTED_LOCK_OWNERS.entrySet().iterator();
                            while (true) {
                                Map.Entry<String, DistributedLockOwner> entry;
                                if (!iterator.hasNext()) continue block3;
                                entry = iterator.next();
                                boolean expired = SystemClockKit.now() - entry.getValue().getLastPingPongTimeMillis() > (long)DistributedLockConfig.EXPIRE_SECONDS.intValue();
                                if (!expired) continue;
                                DISTRIBUTED_LOCK_OWNERS.remove(entry.getKey());
                                log.info("DistributedReentrantLock ping pong lock expired for resource {}", (Object)entry.getKey());
                            }
                            break;
                        }
                    }
                    catch (Exception ex) {
                        log.error("ping Pong Thread error", (Throwable)ex);
                        continue;
                    }
                    break;
                }
            }
        };
        pingPong.setDaemon(true);
        pingPong.start();
    }

    static {
        PING_PONG_DEADLINE = 10000L;
    }
}

