/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.http.request;

import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.openingo.java.lang.ThreadLocalX;
import org.openingo.jdkits.sys.SystemClockKit;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.boot.extension.http.request.HttpRequestReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class HttpRequestLogAspect {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestLogAspect.class);
    private final ThreadLocalX<Long> PROCESSING_TIME_HOLDER = new ThreadLocalX();

    private void handlerStart() {
        this.PROCESSING_TIME_HOLDER.set((Object)SystemClockKit.now());
    }

    private float getProcessingSeconds() {
        long startTime = (Long)this.PROCESSING_TIME_HOLDER.getRemove();
        return (float)(SystemClockKit.now() - startTime) / 1000.0f;
    }

    @Pointcut(value="execution(public * *.*..controller..*.*(..))")
    public void log() {
    }

    @Around(value="log()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        this.handlerStart();
        Object proceed = point.proceed();
        float processingTime = this.getProcessingSeconds();
        HttpRequestReporter httpRequestReporter = HttpRequestReporter.getInstance();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (ValidateKit.isNull((Object)request)) {
            httpRequestReporter.report("\n****************************************************************\n:: SpringApplicationX :: for current request report information \n****************************************************************\nProcessing Time  : " + processingTime + "s\n");
            return proceed;
        }
        httpRequestReporter.setProcessingTime(processingTime);
        httpRequestReporter.setPoint(point);
        httpRequestReporter.setRequest(request);
        httpRequestReporter.setResponseData(proceed);
        httpRequestReporter.report();
        return proceed;
    }
}

