/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.idempotent;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.openingo.jdkits.lang.StrKit;
import org.openingo.spring.boot.extension.distributedlock.lock.DistributedLock;
import org.openingo.spring.boot.extension.idempotent.annotation.Idempotent;
import org.openingo.spring.boot.extension.idempotent.annotation.IdempotentKey;
import org.openingo.spring.boot.extension.idempotent.store.IdempotentStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

@Aspect
public class IdempotentAspect {
    private static final Logger log = LoggerFactory.getLogger(IdempotentAspect.class);
    private final IdempotentStore idempotentStore;
    private static final String KEY_SPACER = "-";
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private static final LocalVariableTableParameterNameDiscoverer DISCOVERER = new LocalVariableTableParameterNameDiscoverer();

    public IdempotentAspect(IdempotentStore idempotentStore) {
        this.idempotentStore = idempotentStore;
    }

    @Pointcut(value="@annotation(org.openingo.spring.boot.extension.idempotent.annotation.Idempotent)")
    public void idempotentPointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="idempotentPointcut()&&@annotation(idempotent)")
    public Object idempotentExecute(ProceedingJoinPoint joinPoint, Idempotent idempotent) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method targetMethod = methodSignature.getMethod();
        Object[] args = joinPoint.getArgs();
        String idempotentKey = this.getIdempotentKey(idempotent, targetMethod, args);
        Assert.hasText((String)idempotentKey, (String)"idempotent key is empty");
        StringBuilder idempotentKeyBuilder = new StringBuilder(targetMethod.getDeclaringClass().getName());
        idempotentKeyBuilder.append(".").append(targetMethod.getName());
        for (Class<?> paramType : targetMethod.getParameterTypes()) {
            idempotentKeyBuilder.append(KEY_SPACER).append(paramType.getName());
        }
        idempotentKey = idempotentKeyBuilder.append(KEY_SPACER).append(idempotentKey).toString().toLowerCase().trim();
        log.info("idempotent key {} args {}", (Object)idempotentKey, (Object)Arrays.toString(args));
        String lockKey = this.getLockKey(idempotentKey);
        log.info("lock key {}", (Object)lockKey);
        Lock lock = DistributedLock.newLock(lockKey);
        try {
            Object object;
            log.info("try get distribute lock for idempotent");
            Assert.isTrue((boolean)lock.tryLock(), (String)"try lock error, wait a minutes");
            Object data = this.idempotentStore.getData(idempotentKey, targetMethod.getReturnType());
            if (Objects.nonNull(data)) {
                log.info("data from the history");
                object = data;
                return object;
            }
            data = joinPoint.proceed(args);
            this.idempotentStore.saveData(idempotentKey, data, idempotent.expireMinutes());
            object = data;
            return object;
        }
        finally {
            log.info("distribute unlock for idempotent");
            lock.unlock();
        }
    }

    private String getLockKey(String idempotentKey) {
        return String.format("idempotent-locks:%s", idempotentKey);
    }

    private String getIdempotentKey(Idempotent idempotent, Method targetMethod, Object[] args) throws Exception {
        String key = "";
        String keyEl = idempotent.keyEl();
        if (StrKit.notBlank((CharSequence)keyEl)) {
            key = IdempotentAspect.eval(keyEl, targetMethod, args);
        }
        if (StrKit.notBlank((CharSequence)key)) {
            return key;
        }
        Annotation[][] paramsAnnotations = targetMethod.getParameterAnnotations();
        for (int idx = 0; idx < paramsAnnotations.length; ++idx) {
            boolean idempotentKeyExist = false;
            for (Annotation annotation : paramsAnnotations[idx]) {
                idempotentKeyExist = annotation instanceof IdempotentKey;
                if (!idempotentKeyExist) continue;
                Object tempArg = args[idx];
                key = tempArg == null ? "" : tempArg.toString();
                break;
            }
            if (idempotentKeyExist) break;
        }
        if (StrKit.notBlank((CharSequence)key)) {
            return key;
        }
        return key;
    }

    private static String eval(String el, Method targetMethod, Object[] args) {
        String[] parameterNames = DISCOVERER.getParameterNames(targetMethod);
        StandardEvaluationContext context = new StandardEvaluationContext();
        if (Objects.nonNull(parameterNames)) {
            for (int len = 0; len < parameterNames.length; ++len) {
                context.setVariable(parameterNames[len], args[len]);
            }
        }
        Expression expression = PARSER.parseExpression(el);
        return (String)expression.getValue((EvaluationContext)context, String.class);
    }
}

