/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.mq.rocket;

import java.util.Set;
import javax.annotation.Resource;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProducer<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractProducer.class);
    @Resource
    protected RocketMQTemplate rocketMqTemplate;

    public boolean syncSendMessage(String topic, T payload) {
        return this.send(topic, payload);
    }

    public boolean syncSendMessage(String topic, String tags, T payload) {
        return this.send(String.format("%s:%s", topic, tags), payload);
    }

    public void asyncSendMessage(String topic, T payload, SendCallback sendCallback) {
        this.send(topic, payload, sendCallback);
    }

    public void asyncSendMessage(String topic, String tags, T payload, SendCallback sendCallback) {
        this.send(String.format("%s:%s", topic, tags), payload, sendCallback);
    }

    public boolean syncSendMessages(String topic, Set<T> payloads) {
        return this.send(topic, payloads);
    }

    public boolean syncSendMessages(String topic, String tags, Set<T> payloads) {
        return this.send(String.format("%s:%s", topic, tags), payloads);
    }

    public void asyncSendMessage(String topic, Set<T> payloads, SendCallback sendCallback) {
        this.send(topic, payloads, sendCallback);
    }

    public void asyncSendMessages(String topic, String tags, Set<T> payloads, SendCallback sendCallback) {
        this.send(String.format("%s:%s", topic, tags), payloads, sendCallback);
    }

    private boolean send(String destination, Object payloads) {
        log.info("sync send destination {} payloads {}", (Object)destination, payloads);
        SendResult sendResult = this.rocketMqTemplate.syncSend(destination, payloads);
        boolean ret = SendStatus.SEND_OK.equals((Object)sendResult.getSendStatus());
        log.info("send data to rocketMQ result {} {}!", (Object)sendResult, (Object)(ret ? "success" : "failed"));
        return ret;
    }

    private void send(String destination, Object payloads, SendCallback sendCallback) {
        log.info("async send destination {} payloads {}", (Object)destination, payloads);
        this.rocketMqTemplate.asyncSend(destination, payloads, sendCallback);
    }
}

