/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.contree.service.notify;

import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.openingo.contree.entity.ConTreeNode;
import org.openingo.contree.service.notify.ConTreeObservable;

public interface IConTreeObserver
extends Observer {
    @Override
    default public void update(Observable o, Object arg) {
        if (o instanceof ConTreeObservable) {
            ConTreeObservable.NotifyData notifyData = (ConTreeObservable.NotifyData)arg;
            String treeCode = notifyData.treeCode;
            List<ConTreeNode> nodes = Collections.unmodifiableList((List)notifyData.notifyData);
            switch (notifyData.notifyType) {
                case DELETE: {
                    this.onTreeNodeDelete(treeCode, nodes);
                    break;
                }
                case UPDATE: {
                    this.onTreeNodeUpdate(treeCode, nodes);
                    break;
                }
                case CREATE: {
                    this.onTreeNodeCreate(treeCode, nodes);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + (Object)((Object)notifyData.notifyType));
                }
            }
        }
    }

    default public void onTreeNodeCreate(String treeCode, List<ConTreeNode> nodes) {
    }

    default public void onTreeNodeDelete(String treeCode, List<ConTreeNode> nodes) {
    }

    default public void onTreeNodeUpdate(String treeCode, List<ConTreeNode> nodes) {
    }
}

