/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.contree.config;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import java.time.LocalDateTime;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MetaObjectHandler.class})
public class TimeFillConfig {
    @Bean
    @ConditionalOnMissingBean(name={"timeFillMetaObjectHandler"})
    public TimeFillMetaObjectHandler timeFillMetaObjectHandler() {
        return new TimeFillMetaObjectHandler();
    }

    static class TimeFillMetaObjectHandler
    implements MetaObjectHandler {
        TimeFillMetaObjectHandler() {
        }

        public void insertFill(MetaObject metaObject) {
            boolean hasCreateTime = metaObject.hasGetter("createTime");
            if (hasCreateTime) {
                metaObject.setValue("createTime", (Object)LocalDateTime.now());
            }
            this.updateFill(metaObject);
        }

        public void updateFill(MetaObject metaObject) {
            boolean hasUpdateTime = metaObject.hasGetter("updateTime");
            if (hasUpdateTime) {
                metaObject.setValue("updateTime", (Object)LocalDateTime.now());
            }
        }
    }
}

