/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.contree.service.impl;

import java.util.List;
import java.util.Map;
import org.openingo.contree.entity.ConTreeNode;
import org.openingo.contree.notify.ConTreeObservable;
import org.openingo.contree.notify.IConTreeObserver;
import org.openingo.contree.service.IConTreeNodeNotifyService;
import org.openingo.jdkits.validate.ValidateKit;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class ConTreeNodeNotifyServiceImpl
implements IConTreeNodeNotifyService,
ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private ConTreeObservable conTreeObservable = new ConTreeObservable();

    public void afterPropertiesSet() throws Exception {
        Map treeObserverMap = this.applicationContext.getBeansOfType(IConTreeObserver.class);
        if (ValidateKit.isNotNull((Object)treeObserverMap)) {
            treeObserverMap.values().forEach(this.conTreeObservable::addObserver);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void addNode(String treeCode, ConTreeNode conTreeNode) {
        this.conTreeObservable.notifyCreateActionToObservers(treeCode, conTreeNode);
    }

    @Override
    public void editNode(String treeCode, ConTreeNode conTreeNode) {
        this.conTreeObservable.notifyUpdateActionToObservers(treeCode, conTreeNode);
    }

    @Override
    public void deleteNode(String treeCode, List<ConTreeNode> conTreeNodes) {
        this.conTreeObservable.notifyDeleteActionToObservers(treeCode, conTreeNodes);
    }
}

