/*
 * MIT License
 *
 * Copyright (c) 2020 OpeningO Co.,Ltd.
 *
 *    https://openingo.org
 *    contactus(at)openingo.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package org.openingo.contree.config;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.time.LocalDateTime;

/**
 * TimeFillConfig
 *
 * @author Qicz
 */
@Configuration
@ConditionalOnClass({MetaObjectHandler.class})
public class TimeFillConfig {

    @Bean
    @ConditionalOnMissingBean(name = "timeFillMetaObjectHandler")
    public TimeFillMetaObjectHandler timeFillMetaObjectHandler() {
        return new TimeFillMetaObjectHandler();
    }

    /**
     * 时间自动填充
     *
     * @author Qicz
     */
    static class TimeFillMetaObjectHandler implements MetaObjectHandler {

        @Override
        public void insertFill(MetaObject metaObject) {
            boolean hasCreateTime = metaObject.hasGetter("createTime");
            if (hasCreateTime) {
                metaObject.setValue("createTime", LocalDateTime.now());
            }

            this.updateFill(metaObject);
        }

        @Override
        public void updateFill(MetaObject metaObject) {
            boolean hasUpdateTime = metaObject.hasGetter("updateTime");
            if (hasUpdateTime) {
                metaObject.setValue("updateTime", LocalDateTime.now());
            }
        }
    }
}
