/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.contree.biz.impl;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.openingo.contree.base.entity.ConTreeNodeDO;
import org.openingo.contree.biz.IConTreeNodeBiz;
import org.openingo.contree.bo.NodeExtensionObj;
import org.openingo.contree.service.IConTreeNodeService;
import org.openingo.contree.vo.ConTreeNodeReorderVO;
import org.openingo.contree.vo.ConTreeNodeVO;
import org.openingo.contree.vo.list.ConTreeNodeListReqVO;
import org.openingo.contree.vo.list.ConTreeNodeListRespVO;
import org.openingo.jdkits.collection.ListKit;
import org.openingo.jdkits.json.JacksonKit;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.exception.ServiceException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConTreeNodeBizImpl
implements IConTreeNodeBiz {
    @Autowired
    private IConTreeNodeService conTreeNodeService;

    private boolean saveOrUpdateNode(ConTreeNodeVO conTreeNodeVO) {
        ConTreeNodeDO conTreeNodeDO = new ConTreeNodeDO();
        Object nodeExtension = conTreeNodeVO.getNodeExtension();
        if (ValidateKit.isNotNull((Object)nodeExtension)) {
            conTreeNodeVO.setNodeExtension(JacksonKit.toJson((Object)NodeExtensionObj.object(nodeExtension)));
        }
        BeanUtils.copyProperties((Object)conTreeNodeVO, (Object)conTreeNodeDO);
        return this.conTreeNodeService.saveOrUpdate((Object)conTreeNodeDO);
    }

    private void validateNode(String treeCode, Integer nodeId) {
        if (!this.conTreeNodeService.isValidNode(treeCode, nodeId)) {
            throw new ServiceException("\u6570\u636e\u4e0d\u5408\u6cd5[treeCode\u4e0enodeId\u4e0d\u5339\u914d\uff0c\u6570\u636e\u53ef\u80fd\u4e0d\u5b58\u5728].");
        }
    }

    @Override
    public boolean addNode(ConTreeNodeVO conTreeNodeVO) {
        return this.saveOrUpdateNode(conTreeNodeVO);
    }

    @Override
    public boolean editNode(ConTreeNodeVO conTreeNodeVO) {
        this.validateNode(conTreeNodeVO.getTreeCode(), conTreeNodeVO.getNodeId());
        return this.saveOrUpdateNode(conTreeNodeVO);
    }

    @Override
    public boolean deleteNode(ConTreeNodeVO conTreeNodeVO) {
        boolean ret = false;
        List listNodes = null;
        String treeCode = conTreeNodeVO.getTreeCode();
        Integer rootNodeId = conTreeNodeVO.getRootNodeId();
        if ("cascade".equals(conTreeNodeVO.getMode())) {
            listNodes = this.conTreeNodeService.listNodes(treeCode, rootNodeId, null, true);
            List ids = listNodes.stream().map(ConTreeNodeDO::getNodeId).collect(Collectors.toList());
            if (ValidateKit.isNotEmpty(ids)) {
                ret = this.conTreeNodeService.removeByIds(ids);
            }
        } else {
            listNodes = this.conTreeNodeService.listNodes(treeCode, rootNodeId, null, false);
            if (ValidateKit.isNotEmpty((Object)listNodes)) {
                throw new ServiceException(String.format("\u627e\u5230%d\u4e2a\u5b50\u8282\u70b9\uff0c\u4e0d\u53ef\u5220\u9664.", listNodes.size()));
            }
        }
        return ret;
    }

    @Override
    public boolean reorderNodes(ConTreeNodeReorderVO conTreeNodeReorderVO) {
        List treeNodes = ListKit.emptyArrayList();
        conTreeNodeReorderVO.getReorderNodes().forEach(item -> {
            ConTreeNodeDO conTreeNodeDO = new ConTreeNodeDO();
            conTreeNodeDO.setNodeId(item.getNodeId());
            conTreeNodeDO.setNodeOrder(item.getNodeOrder());
            treeNodes.add(conTreeNodeDO);
        });
        return this.conTreeNodeService.updateBatchById((Collection)treeNodes);
    }

    @Override
    public ConTreeNodeListRespVO listNodes(ConTreeNodeListReqVO conTreeNodeListReqVO) {
        String treeCode = conTreeNodeListReqVO.getTreeCode();
        Integer rootNodeId = conTreeNodeListReqVO.getRootNodeId();
        String nodeName = conTreeNodeListReqVO.getNodeName();
        String fetchType = conTreeNodeListReqVO.getFetchType();
        List listNodes = this.conTreeNodeService.listNodes(treeCode, rootNodeId, nodeName, "full".equals(fetchType));
        ConTreeNodeListRespVO listRespVO = new ConTreeNodeListRespVO();
        List treeRespNodes = ListKit.emptyArrayList();
        for (ConTreeNodeDO conTreeNodeDO : listNodes) {
            ConTreeNodeListRespVO.ConTreeNodeRespVO respVO = new ConTreeNodeListRespVO.ConTreeNodeRespVO();
            BeanUtils.copyProperties((Object)conTreeNodeDO, (Object)respVO);
            String nodeExtension = conTreeNodeDO.getNodeExtension();
            if (ValidateKit.isNotNull((Object)nodeExtension)) {
                NodeExtensionObj nodeExtensionObj = (NodeExtensionObj)JacksonKit.toObj((String)nodeExtension, NodeExtensionObj.class);
                respVO.setNodeExtension(nodeExtensionObj.getObject());
            }
            treeRespNodes.add(respVO);
        }
        listRespVO.setNodes(treeRespNodes);
        listRespVO.redraw(ValidateKit.isEmpty((Object)nodeName), rootNodeId);
        return listRespVO;
    }
}

