/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.contree.vo.list;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.openingo.contree.vo.ConTreeNodeVO;
import org.openingo.jdkits.tree.ITreeNode;
import org.openingo.jdkits.tree.TreeBuilder;
import org.openingo.jdkits.validate.ValidateKit;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ConTreeNodeListRespVO
implements Serializable {
    private Integer nodeCount;
    private List<ConTreeNodeRespVO> nodes;

    public void redraw(boolean toTree, Integer rootNodeId) {
        int nodeCount = 0;
        if (ValidateKit.isNotEmpty(this.nodes)) {
            nodeCount = this.nodes.size();
            if (toTree) {
                Integer zero = 0;
                this.nodes = zero.equals(rootNodeId) ? TreeBuilder.buildTree((TreeBuilder.RootNode)TreeBuilder.RootNode.ZERO_ID, this.nodes, Comparator.comparingInt(ConTreeNodeVO::getNodeOrder)) : TreeBuilder.buildTree((String)rootNodeId.toString(), this.nodes, Comparator.comparingInt(ConTreeNodeVO::getNodeOrder));
            }
        }
        this.setNodeCount(nodeCount);
    }

    public Integer getNodeCount() {
        return this.nodeCount;
    }

    public List<ConTreeNodeRespVO> getNodes() {
        return this.nodes;
    }

    public void setNodeCount(Integer nodeCount) {
        this.nodeCount = nodeCount;
    }

    public void setNodes(List<ConTreeNodeRespVO> nodes) {
        this.nodes = nodes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConTreeNodeListRespVO)) {
            return false;
        }
        ConTreeNodeListRespVO other = (ConTreeNodeListRespVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$nodeCount = this.getNodeCount();
        Integer other$nodeCount = other.getNodeCount();
        if (this$nodeCount == null ? other$nodeCount != null : !((Object)this$nodeCount).equals(other$nodeCount)) {
            return false;
        }
        List<ConTreeNodeRespVO> this$nodes = this.getNodes();
        List<ConTreeNodeRespVO> other$nodes = other.getNodes();
        return !(this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConTreeNodeListRespVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $nodeCount = this.getNodeCount();
        result = result * 59 + ($nodeCount == null ? 43 : ((Object)$nodeCount).hashCode());
        List<ConTreeNodeRespVO> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        return result;
    }

    public String toString() {
        return "ConTreeNodeListRespVO(nodeCount=" + this.getNodeCount() + ", nodes=" + this.getNodes() + ")";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class ConTreeNodeRespVO
    extends ConTreeNodeVO
    implements ITreeNode<ConTreeNodeRespVO> {
        private Integer sonCount;
        private List<ConTreeNodeRespVO> sonNodes;

        public String nodeId() {
            return this.getNodeId().toString();
        }

        public String nodeParentId() {
            return this.getRootNodeId().toString();
        }

        public void putChildNodes(List<ConTreeNodeRespVO> childNodes) {
            this.sonNodes = childNodes;
            this.sonCount = childNodes.size();
        }

        public Integer getSonCount() {
            return this.sonCount;
        }

        public List<ConTreeNodeRespVO> getSonNodes() {
            return this.sonNodes;
        }

        public void setSonCount(Integer sonCount) {
            this.sonCount = sonCount;
        }

        public void setSonNodes(List<ConTreeNodeRespVO> sonNodes) {
            this.sonNodes = sonNodes;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConTreeNodeRespVO)) {
                return false;
            }
            ConTreeNodeRespVO other = (ConTreeNodeRespVO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$sonCount = this.getSonCount();
            Integer other$sonCount = other.getSonCount();
            if (this$sonCount == null ? other$sonCount != null : !((Object)this$sonCount).equals(other$sonCount)) {
                return false;
            }
            List<ConTreeNodeRespVO> this$sonNodes = this.getSonNodes();
            List<ConTreeNodeRespVO> other$sonNodes = other.getSonNodes();
            return !(this$sonNodes == null ? other$sonNodes != null : !((Object)this$sonNodes).equals(other$sonNodes));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ConTreeNodeRespVO;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $sonCount = this.getSonCount();
            result = result * 59 + ($sonCount == null ? 43 : ((Object)$sonCount).hashCode());
            List<ConTreeNodeRespVO> $sonNodes = this.getSonNodes();
            result = result * 59 + ($sonNodes == null ? 43 : ((Object)$sonNodes).hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "ConTreeNodeListRespVO.ConTreeNodeRespVO(sonCount=" + this.getSonCount() + ", sonNodes=" + this.getSonNodes() + ")";
        }
    }
}

