/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.contree.biz.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.openingo.contree.base.entity.ConTreeNodeDO;
import org.openingo.contree.biz.IConTreeNodeBiz;
import org.openingo.contree.bo.NodeExtensionObj;
import org.openingo.contree.entity.ConTreeNode;
import org.openingo.contree.service.IConTreeNodeNotifyService;
import org.openingo.contree.service.IConTreeNodeService;
import org.openingo.contree.vo.ConTreeNodeReorderVO;
import org.openingo.contree.vo.ConTreeNodeVO;
import org.openingo.contree.vo.list.ConTreeNodeListReqVO;
import org.openingo.contree.vo.list.ConTreeNodeListRespVO;
import org.openingo.jdkits.collection.ListKit;
import org.openingo.jdkits.json.JacksonKit;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConTreeNodeBizImpl
implements IConTreeNodeBiz {
    private static final Logger log = LoggerFactory.getLogger(ConTreeNodeBizImpl.class);
    @Autowired
    private IConTreeNodeService conTreeNodeService;
    @Autowired
    private IConTreeNodeNotifyService conTreeNodeNotifyService;

    private boolean saveOrUpdateNode(ConTreeNodeVO conTreeNodeVO) {
        ConTreeNodeDO conTreeNodeDO = new ConTreeNodeDO();
        Object nodeExtension = conTreeNodeVO.getNodeExtension();
        BeanUtils.copyProperties((Object)conTreeNodeVO, (Object)conTreeNodeDO);
        if (ValidateKit.isNotNull((Object)nodeExtension)) {
            nodeExtension = JacksonKit.toJson((Object)NodeExtensionObj.object(nodeExtension));
            conTreeNodeDO.setNodeExtension(nodeExtension.toString());
        }
        boolean ret = this.conTreeNodeService.saveOrUpdate((Object)conTreeNodeDO);
        conTreeNodeVO.setNodeId(conTreeNodeDO.getNodeId());
        return ret;
    }

    private ConTreeNodeDO validateNode(String treeCode, Integer nodeId) {
        boolean check;
        ConTreeNodeDO nodeDO = (ConTreeNodeDO)this.conTreeNodeService.getById((Serializable)nodeId);
        boolean bl = check = ValidateKit.isNotNull((Object)nodeDO) && treeCode.equals(nodeDO.getTreeCode());
        if (!check) {
            throw new ServiceException("\u6570\u636e\u4e0d\u5408\u6cd5[treeCode\u4e0enodeId\u4e0d\u5339\u914d\uff0c\u6570\u636e\u53ef\u80fd\u4e0d\u5b58\u5728].");
        }
        return nodeDO;
    }

    private ConTreeNode toNode(ConTreeNodeVO conTreeNodeVO) {
        return new ConTreeNode(conTreeNodeVO.getNodeId(), conTreeNodeVO.getNodeExtension());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean addNode(ConTreeNodeVO conTreeNodeVO) {
        boolean ret = this.saveOrUpdateNode(conTreeNodeVO);
        if (!ret) {
            log.info("==\u6dfb\u52a0\u8282\u70b9\u5931\u8d25\u3002(\u4e0d\u8fdb\u884c\u53d8\u52a8\u901a\u77e5)==");
            throw new ServiceException("\u8282\u70b9\u6dfb\u52a0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5!");
        }
        this.conTreeNodeNotifyService.addNode(conTreeNodeVO.getTreeCode(), this.toNode(conTreeNodeVO));
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean editNode(ConTreeNodeVO conTreeNodeVO) {
        String treeCode = conTreeNodeVO.getTreeCode();
        ConTreeNodeDO treeNodeDO = this.validateNode(treeCode, conTreeNodeVO.getNodeId());
        boolean ret = this.saveOrUpdateNode(conTreeNodeVO);
        if (!ret) {
            log.info("==\u7f16\u8f91\u8282\u70b9\u5931\u8d25\u3002(\u4e0d\u8fdb\u884c\u53d8\u52a8\u901a\u77e5)==");
            throw new ServiceException("\u7f16\u8f91\u8282\u70b9\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5!");
        }
        String nodeExtension = treeNodeDO.getNodeExtension();
        if (ValidateKit.isNull((Object)conTreeNodeVO.getNodeExtension()) && ValidateKit.isNotNull((Object)nodeExtension)) {
            NodeExtensionObj nodeExtensionObj = (NodeExtensionObj)JacksonKit.toObj((String)nodeExtension, NodeExtensionObj.class);
            conTreeNodeVO.setNodeExtension(nodeExtensionObj.getObject());
        }
        this.conTreeNodeNotifyService.editNode(treeCode, this.toNode(conTreeNodeVO));
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteNode(ConTreeNodeVO conTreeNodeVO) {
        boolean ret = false;
        String treeCode = conTreeNodeVO.getTreeCode();
        Integer rootNodeId = conTreeNodeVO.getRootNodeId();
        this.validateNode(treeCode, rootNodeId);
        boolean recursion = "cascade".equals(conTreeNodeVO.getMode());
        List listNodes = this.conTreeNodeService.listNodes(treeCode, rootNodeId, null, recursion);
        List deleteNodes = ListKit.emptyArrayList();
        if (ValidateKit.isNotEmpty((Object)listNodes)) {
            if (!recursion) {
                throw new ServiceException(String.format("\u627e\u5230%d\u4e2a\u5b50\u8282\u70b9\uff0c\u4e0d\u53ef\u5220\u9664.", listNodes.size()));
            }
            List ids = listNodes.stream().map(ConTreeNodeDO::getNodeId).collect(Collectors.toList());
            if (ValidateKit.isNotEmpty(ids)) {
                ret = this.conTreeNodeService.removeByIds(ids);
            }
            if (!ret) {
                log.info("==\u5220\u9664\u7684\u8282\u70b9\u5931\u8d25\u3002(\u4e0d\u8fdb\u884c\u53d8\u52a8\u901a\u77e5)==");
                throw new ServiceException("\u5220\u9664\u7684\u8282\u70b9\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5!");
            }
            for (ConTreeNodeDO listNode : listNodes) {
                String nodeExtension = listNode.getNodeExtension();
                Object obj = null;
                if (ValidateKit.isNotNull((Object)nodeExtension)) {
                    NodeExtensionObj nodeExtensionObj = (NodeExtensionObj)JacksonKit.toObj((String)nodeExtension, NodeExtensionObj.class);
                    obj = nodeExtensionObj.getObject();
                }
                deleteNodes.add(new ConTreeNode(listNode.getNodeId(), obj));
            }
        }
        this.conTreeNodeNotifyService.deleteNode(treeCode, deleteNodes);
        return true;
    }

    @Override
    public boolean reorderNodes(ConTreeNodeReorderVO conTreeNodeReorderVO) {
        List treeNodes = ListKit.emptyArrayList();
        conTreeNodeReorderVO.getReorderNodes().forEach(item -> {
            ConTreeNodeDO conTreeNodeDO = new ConTreeNodeDO();
            conTreeNodeDO.setNodeId(item.getNodeId());
            conTreeNodeDO.setNodeOrder(item.getNodeOrder());
            treeNodes.add(conTreeNodeDO);
        });
        return this.conTreeNodeService.updateBatchById((Collection)treeNodes);
    }

    @Override
    public ConTreeNodeListRespVO listNodes(ConTreeNodeListReqVO conTreeNodeListReqVO) {
        String treeCode = conTreeNodeListReqVO.getTreeCode();
        Integer rootNodeId = conTreeNodeListReqVO.getRootNodeId();
        String nodeName = conTreeNodeListReqVO.getNodeName();
        String fetchType = conTreeNodeListReqVO.getFetchType();
        boolean recursion = "full".equals(fetchType);
        List listNodes = this.conTreeNodeService.listNodes(treeCode, rootNodeId, nodeName, recursion);
        ConTreeNodeListRespVO listRespVO = new ConTreeNodeListRespVO();
        List treeRespNodes = ListKit.emptyArrayList();
        for (ConTreeNodeDO conTreeNodeDO : listNodes) {
            ConTreeNodeListRespVO.ConTreeNodeRespVO respVO = new ConTreeNodeListRespVO.ConTreeNodeRespVO();
            BeanUtils.copyProperties((Object)conTreeNodeDO, (Object)respVO);
            String nodeExtension = conTreeNodeDO.getNodeExtension();
            if (ValidateKit.isNotNull((Object)nodeExtension)) {
                NodeExtensionObj nodeExtensionObj = (NodeExtensionObj)JacksonKit.toObj((String)nodeExtension, NodeExtensionObj.class);
                respVO.setNodeExtension(nodeExtensionObj.getObject());
            }
            treeRespNodes.add(respVO);
        }
        listRespVO.setNodes(treeRespNodes);
        listRespVO.redraw(ValidateKit.isEmpty((Object)nodeName), rootNodeId);
        return listRespVO;
    }
}

