/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.contree.controller;

import javax.validation.Valid;
import org.openingo.contree.biz.IConTreeNodeBiz;
import org.openingo.contree.vo.ConTreeNodeReorderVO;
import org.openingo.contree.vo.ConTreeNodeVO;
import org.openingo.contree.vo.VoValidatorGroups;
import org.openingo.contree.vo.list.ConTreeNodeListReqVO;
import org.openingo.jdkits.http.RespData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/tree/node"})
public class ConTreeNodeController {
    @Autowired
    IConTreeNodeBiz conTreeNodeBiz;

    @PostMapping(value={"/add"})
    @Validated(value={VoValidatorGroups.Insert.class})
    public RespData addNode(@Valid @RequestBody ConTreeNodeVO conTreeNodeVO) {
        this.conTreeNodeBiz.addNode(conTreeNodeVO);
        return RespData.success();
    }

    @PostMapping(value={"/edit"})
    @PutMapping(value={"/"})
    @Validated(value={VoValidatorGroups.Update.class})
    public RespData editNode(@Valid @RequestBody ConTreeNodeVO conTreeNodeVO) {
        this.conTreeNodeBiz.editNode(conTreeNodeVO);
        return RespData.success();
    }

    @PostMapping(value={"/delete"})
    @DeleteMapping(value={"/"})
    @Validated(value={VoValidatorGroups.Delete.class})
    public RespData deleteNode(@Valid @RequestBody ConTreeNodeVO conTreeNodeVO) {
        this.conTreeNodeBiz.deleteNode(conTreeNodeVO);
        return RespData.success();
    }

    @PostMapping(value={"/reorder"})
    @PutMapping(value={"/reorder"})
    @Validated
    public RespData reorderNodes(@Valid @RequestBody ConTreeNodeReorderVO conTreeNodeReorderVO) {
        this.conTreeNodeBiz.reorderNodes(conTreeNodeReorderVO);
        return RespData.success();
    }

    @GetMapping(value={"/list"})
    @Validated
    public RespData listNode(@Valid ConTreeNodeListReqVO conTreeNodeListReqVO) {
        return RespData.success((Object)this.conTreeNodeBiz.listNodes(conTreeNodeListReqVO));
    }
}

