/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.openingo.jdkits.ExceptionKit;
import org.openingo.jdkits.StrKit;

public final class JacksonKit {
    private static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        return objectMapper;
    }

    public static String toJson(Object object) {
        String json = "";
        try {
            json = JacksonKit.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            ExceptionKit.throwRuntimeException(e.getOriginalMessage());
        }
        return json;
    }

    public static String toJson(Object object, JsonInclude.Include include) {
        String json = "";
        try {
            ObjectMapper objectMapper = JacksonKit.getObjectMapper();
            json = objectMapper.writeValueAsString(object);
            objectMapper.setSerializationInclusion(include);
        }
        catch (JsonProcessingException e) {
            ExceptionKit.throwRuntimeException(e.getOriginalMessage());
        }
        return json;
    }

    public static String toJson(Object object, String datePattern) {
        if (StrKit.isBlank(datePattern)) {
            return JacksonKit.toJson(object);
        }
        String json = "";
        try {
            ObjectMapper objectMapper = JacksonKit.getObjectMapper();
            objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(datePattern));
            json = objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            ExceptionKit.throwRuntimeException(e.getOriginalMessage());
        }
        return json;
    }

    public static String toJson(Object object, String datePattern, JsonInclude.Include include) {
        if (StrKit.isBlank(datePattern)) {
            return JacksonKit.toJson(object);
        }
        String json = "";
        try {
            ObjectMapper objectMapper = JacksonKit.getObjectMapper();
            objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(datePattern));
            objectMapper.setSerializationInclusion(include);
            json = objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            ExceptionKit.throwRuntimeException(e.getOriginalMessage());
        }
        return json;
    }

    public static <T> T toObj(String json, Class<T> clazz) {
        Object obj = null;
        if (StrKit.isBlank(json)) {
            return (T)obj;
        }
        try {
            obj = JacksonKit.getObjectMapper().readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            ExceptionKit.throwRuntimeException(e.getOriginalMessage());
        }
        return (T)obj;
    }

    public static <K, V> Map<K, V> toMap(String json) {
        return JacksonKit.toObj(json, Map.class);
    }
}

