/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.cglib.beans.BeanMap;
import org.openingo.jdkits.ClassKit;
import org.openingo.jdkits.ValidateKit;

public final class BeanKit {
    private BeanKit() {
    }

    public static Map<String, Object> beanToMap(Object bean) {
        return null == bean ? null : BeanMap.create((Object)bean);
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> clazz) {
        T bean = ClassKit.newInstance(clazz);
        BeanMap.create(bean).putAll(map);
        return bean;
    }

    public static <T> List<Map<String, Object>> beansToMaps(List<T> beans) {
        if (ValidateKit.isEmpty(beans)) {
            return Collections.emptyList();
        }
        return beans.stream().map(BeanKit::beanToMap).collect(Collectors.toList());
    }

    public static <T> List<T> mapsToBeans(List<Map<String, Object>> maps, Class<T> clazz) {
        if (ValidateKit.isEmpty(maps)) {
            return Collections.emptyList();
        }
        return maps.stream().map(e -> BeanKit.mapToBean(e, clazz)).collect(Collectors.toList());
    }
}

