/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openingo.jdkits.ArrayKit;
import org.openingo.jdkits.AssertKit;
import org.openingo.jdkits.ValidateKit;

public class ListKit {
    public static <T> List<T> emptyArrayList() {
        return new ArrayList();
    }

    public static <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    public static <T> List<T> emptyIfNull(List<T> list) {
        return ValidateKit.isNull(list) ? ListKit.emptyList() : list;
    }

    public static <T> List<T> defaultIfNull(List<T> list, List<T> defaultList) {
        return ValidateKit.isNull(list) ? defaultList : list;
    }

    public static void permutation(List<String> permutationRet, List<List<Object>> list, String prefix, String split) {
        if (ValidateKit.isContainNull(permutationRet, list)) {
            return;
        }
        int size = list.size();
        if (1 == size) {
            for (int i = 0; i < list.get(0).size(); ++i) {
                permutationRet.add(prefix + list.get(0).get(i));
            }
        } else {
            ArrayList permu = new ArrayList(list.get(0));
            ArrayList<List<Object>> now = new ArrayList<List<Object>>(list);
            now.remove(0);
            for (int i = 0; i < permu.size(); ++i) {
                ListKit.permutation(permutationRet, now, prefix + permu.get(i) + split, ":");
            }
        }
    }

    public static <T> T[] toArray(List<T> list) {
        return list.toArray(ArrayKit.empty(list.size()));
    }

    private static <T> List<T> listOps(List<T> list1, List<T> list2, ListOpsEnum opsEnum) {
        if (ValidateKit.isAllNull(list1, list1)) {
            return ListKit.emptyArrayList();
        }
        if (ValidateKit.isEqual(list2, ListKit.defaultIfNull(list1, list2))) {
            return list2;
        }
        if (ValidateKit.isEqual(list1, ListKit.defaultIfNull(list2, list1))) {
            return list1;
        }
        List<T> ret = ListKit.emptyArrayList();
        T[] list1Array = ListKit.toArray(list1);
        T[] list2Array = ListKit.toArray(list2);
        switch (opsEnum) {
            case UNION: {
                ret = Arrays.asList(ArrayKit.union(list1Array, list2Array));
                break;
            }
            case INTERSECT: {
                ret = Arrays.asList(ArrayKit.intersect(list1Array, list2Array));
                break;
            }
            case MINUS: {
                ret = Arrays.asList(ArrayKit.minus(list1Array, list2Array));
            }
        }
        return ret;
    }

    public static <T> List<T> union(List<T> list1, List<T> list2) {
        return ListKit.listOps(list1, list2, ListOpsEnum.UNION);
    }

    public static <T> List<T> intersect(List<T> list1, List<T> list2) {
        return ListKit.listOps(list1, list2, ListOpsEnum.INTERSECT);
    }

    public static <T> List<T> minus(List<T> list1, List<T> list2) {
        return ListKit.listOps(list1, list2, ListOpsEnum.MINUS);
    }

    private static <T> void validateList(List<T> list) {
        AssertKit.notNull(list, "\u5f53\u524d\u64cd\u4f5clist\u4e0d\u80fd\u4e3anull.");
    }

    public static <T> List<T> reverse(List<T> list) {
        ListKit.validateList(list);
        T[] listArray = ListKit.toArray(list);
        ArrayKit.reverse(listArray);
        return ArrayKit.toList(listArray);
    }

    public static <T> List<T> removeAll(List<T> list, List<T> removingList) {
        list.removeAll(removingList);
        return list;
    }

    public static <T> List<T> synchronizedList(List<T> list) {
        ListKit.validateList(list);
        return Collections.synchronizedList(list);
    }

    public static <T> Boolean isNull(List<T> list) {
        return ValidateKit.isNull(list);
    }

    public static <T> Boolean isEmpty(List<T> list) {
        return ListKit.isNull(list) != false || list.isEmpty();
    }

    public static <T> Boolean hasOneElement(List<T> list) {
        ListKit.validateList(list);
        return list.size() == 1;
    }

    public static <T> Boolean hasManyElement(List<T> list) {
        ListKit.validateList(list);
        return list.size() > 1;
    }

    public static <T> void replace(List<T> list, Integer idx, T obj) {
        AssertKit.isTrue(idx < list.size() && idx >= 0, "\u7d22\u5f15\u4e0d\u5408\u6cd5\u3002");
        list.set(idx, obj);
    }

    private static enum ListOpsEnum {
        UNION,
        INTERSECT,
        MINUS;

    }
}

