/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.jdkits;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ArrayKit {
    public static <T> T[] empty(Integer size) {
        return new Object[size.intValue()];
    }

    public static <T> T[] union(T[] arr1, T[] arr2) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T item : arr1) {
            set.add(item);
        }
        for (T item : arr2) {
            set.add(item);
        }
        return set.toArray(ArrayKit.empty(set.size()));
    }

    public static <T> T[] intersect(T[] arr1, T[] arr2) {
        HashMap<T, Boolean> map = new HashMap<T, Boolean>();
        for (T item : arr1) {
            if (map.containsKey(item)) continue;
            map.put(item, Boolean.FALSE);
        }
        for (T item : arr2) {
            if (!map.containsKey(item)) continue;
            map.put(item, Boolean.TRUE);
        }
        LinkedList list = new LinkedList();
        Set entries = map.entrySet();
        for (Map.Entry e : entries) {
            if (!((Boolean)e.getValue()).equals(Boolean.TRUE)) continue;
            list.add(e.getKey());
        }
        return list.toArray(ArrayKit.empty(list.size()));
    }

    public static <T> T[] minus(T[] arr1, T[] arr2) {
        T[] longerArr = arr1;
        T[] shorterArr = arr2;
        if (arr1.length > arr2.length) {
            longerArr = arr2;
            shorterArr = arr1;
        }
        LinkedList<T> list = new LinkedList<T>();
        for (T item : longerArr) {
            if (list.contains(item)) continue;
            list.add(item);
        }
        LinkedList<T> history = new LinkedList<T>();
        for (T item : shorterArr) {
            if (list.contains(item)) {
                history.add(item);
                list.remove(item);
                continue;
            }
            if (history.contains(item)) continue;
            list.add(item);
        }
        return list.toArray(ArrayKit.empty(list.size()));
    }

    public static <T> void reverse(T[] array) {
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            T tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static <T> T[] removeAll(T[] arr, T[] removingArr) {
        LinkedList<T> list = new LinkedList<T>();
        for (T item : arr) {
            if (list.contains(item)) continue;
            list.add(item);
        }
        for (T item : removingArr) {
            if (!list.contains(item)) continue;
            list.remove(item);
        }
        return list.toArray(ArrayKit.empty(list.size()));
    }

    public static <T> List<T> toList(T[] array) {
        return Arrays.asList(array);
    }
}

