/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.jdkits;

import cn.zhucongqi.jdkits.ValidateKit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public final class DDLKit {
    public static final String BIGINT = "bigint";
    public static final String VARCHAR = "varchar";
    public static final String TEXT = "text";
    public static final String TINYTEXT = "tinytext";
    public static final String INT = "int";
    public static final String TINYINT = "tinyint";
    public static final String CHARSET_UTF8MB4 = "utf8mb4";
    public static final String CHARSET_UTF8 = "utf8";

    public static Table createTable(String tableName, String comment) {
        return new Table(tableName, comment);
    }

    public static String createTable(String tableName, String comment, List<Column> columns) {
        return new Table(tableName, comment).addColumns(columns).tableDDL();
    }

    public static Column createColumn(String columnName, String columnType, String comment, int columnSize, Object defaultValue, boolean primaryKey, boolean uniqueKey) {
        return new Column(columnName, columnType, true, comment, columnSize, defaultValue, primaryKey, uniqueKey);
    }

    public static Column createColumn(String columnName, String columnType, boolean unsigned, String comment, int columnSize, Object defaultValue, boolean primaryKey, boolean uniqueKey) {
        return new Column(columnName, columnType, unsigned, comment, columnSize, defaultValue, primaryKey, uniqueKey);
    }

    public static Column createColumn(String columnName, String columnType, String comment, int columnSize, Object defaultValue) {
        return DDLKit.createColumn(columnName, columnType, comment, columnSize, defaultValue, false, false);
    }

    public static Column createPrimaryKey(String columnName, String columnType, String comment, int columnSize, Object defaultValue) {
        return DDLKit.createColumn(columnName, columnType, comment, columnSize, defaultValue, true, false);
    }

    public static Column createUniqueKey(String columnName, String columnType, String comment, int columnSize, Object defaultValue) {
        return DDLKit.createColumn(columnName, columnType, comment, columnSize, defaultValue, false, true);
    }

    public static Column createVarcharColumn(String columnName, String comment, int columnSize, Object defaultValue) {
        return DDLKit.createColumn(columnName, VARCHAR, comment, columnSize, defaultValue, false, false);
    }

    public static Column createTextColumn(String columnName, String comment, int columnSize, Object defaultValue) {
        return DDLKit.createColumn(columnName, TEXT, comment, columnSize, defaultValue, false, false);
    }

    public static Column createTinyTextColumn(String columnName, String comment, int columnSize, Object defaultValue) {
        return DDLKit.createColumn(columnName, TINYTEXT, comment, columnSize, defaultValue, false, false);
    }

    public static Column createIntColumn(String columnName, String comment, int columnSize, Object defaultValue) {
        return DDLKit.createColumn(columnName, INT, comment, columnSize, defaultValue, false, false);
    }

    public static Column createSignedIntColumn(String columnName, String comment, int columnSize, Object defaultValue) {
        return DDLKit.createColumn(columnName, INT, false, comment, columnSize, defaultValue, false, false);
    }

    public static Column createTinyIntColumn(String columnName, String comment, int columnSize, Object defaultValue) {
        return DDLKit.createColumn(columnName, TINYINT, comment, columnSize, defaultValue, false, false);
    }

    public static Column createSignedTinyIntColumn(String columnName, String comment, int columnSize, Object defaultValue) {
        return DDLKit.createColumn(columnName, TINYINT, false, comment, columnSize, defaultValue, false, false);
    }

    public static class Column {
        private String columnName = null;
        private String columnType = null;
        private int columnSize = 10;
        private StringBuilder defaultValue = new StringBuilder();
        private String comment = null;
        private boolean primaryKey = false;
        private boolean uniqueKey = false;
        private boolean unsigned = true;

        public Column(String columnName, String columnType, String comment, int columnSize, String defaultValue) {
            this(columnName, columnType, true, comment, columnSize, defaultValue, false, false);
        }

        public Column(String columnName, String columnType, boolean unsigned, String comment, int columnSize, Object defaultValue, boolean primaryKey, boolean uniqueKey) {
            if (!columnName.startsWith("`")) {
                columnName = "`" + columnName;
            }
            if (!columnName.endsWith("`")) {
                columnName = columnName + "`";
            }
            this.columnName = columnName;
            this.columnType = columnType;
            if (ValidateKit.isNull(defaultValue)) {
                this.defaultValue.append("DEFAULT NULL");
            } else {
                String value = defaultValue.toString();
                value = "".equals(value) || "''".equals(value) ? "''" : "'" + value + "'";
                this.defaultValue.append("NOT NULL DEFAULT ").append(value);
            }
            if (!comment.startsWith("'")) {
                comment = "'" + comment;
            }
            if (!comment.endsWith("'")) {
                comment = comment + "'";
            }
            this.unsigned = unsigned;
            this.comment = comment;
            this.columnSize = columnSize;
            this.primaryKey = primaryKey;
            this.uniqueKey = uniqueKey;
        }

        public String columnDDL() {
            return this.columnName + " " + this.columnType + "(" + this.columnSize + ") " + (this.isNumType() ? "unsigned " : "") + this.defaultValue + " COMMENT " + this.comment;
        }

        private boolean isNumType() {
            return (DDLKit.INT.equals(this.columnType) || DDLKit.TINYINT.equals(this.columnType) || DDLKit.BIGINT.equals(this.columnType)) && this.unsigned;
        }
    }

    public static class Table {
        private String tableName = null;
        private String comment = null;
        HashMap<String, Column> columnsMap = new LinkedHashMap<String, Column>();
        private List<Column> primaryKeys = new ArrayList<Column>();
        private List<Column> uniqueKeys = new ArrayList<Column>();
        private Boolean generateId = true;
        private Boolean pretty = true;
        private String charset = "utf8mb4";

        private Table(String tableName, String comment) {
            this.tableName = tableName;
            if (!comment.startsWith("`")) {
                comment = "'" + comment;
            }
            if (!comment.endsWith("`")) {
                comment = comment + "'";
            }
            this.comment = comment;
        }

        public Table addColumn(Column column) {
            if (ValidateKit.isNull(column)) {
                return this;
            }
            if (!this.columnsMap.containsKey(column.columnName)) {
                this.columnsMap.put(column.columnName, column);
            }
            if (column.primaryKey) {
                this.primaryKeys.add(column);
            }
            if (column.uniqueKey) {
                this.uniqueKeys.add(column);
            }
            return this;
        }

        public Table addColumns(List<Column> columns) {
            if (ValidateKit.isNull(columns)) {
                return this;
            }
            for (Column column : columns) {
                this.addColumn(column);
            }
            return this;
        }

        public void setGenerateId(Boolean generateId) {
            this.generateId = generateId;
        }

        public void setPretty(Boolean pretty) {
            this.pretty = pretty;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public String tableDDL() {
            StringBuilder sqlBuilder = new StringBuilder();
            String pretty = this.pretty != false ? "\n" : "";
            sqlBuilder.append("CREATE TABLE `").append(this.tableName).append("` (").append(pretty);
            sqlBuilder.append(this.generateId != false ? "`id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '\u7d22\u5f15'," + pretty : "");
            Iterator<String> keyIterator = this.columnsMap.keySet().iterator();
            int size = this.columnsMap.size();
            int idx = 0;
            while (keyIterator.hasNext()) {
                String key = keyIterator.next();
                sqlBuilder.append(this.columnsMap.get(key).columnDDL());
                if (idx != size - 1) {
                    sqlBuilder.append(",").append(pretty);
                }
                ++idx;
            }
            sqlBuilder.append(this.generateId != false ? "," + pretty + "PRIMARY KEY (`id`" : "");
            for (Column column : this.primaryKeys) {
                sqlBuilder.append(",").append(column.columnName);
            }
            sqlBuilder.append(this.generateId != false ? ")" : "");
            for (Column column : this.uniqueKeys) {
                sqlBuilder.append("," + pretty + "UNIQUE KEY").append(column.columnName).append("(").append(column.columnName).append(")");
            }
            sqlBuilder.append(pretty).append(") ENGINE=InnoDB CHARSET=").append(this.charset).append(" COMMENT=").append(this.comment).append(";");
            return sqlBuilder.toString();
        }
    }
}

