/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.jdkits;

import cn.zhucongqi.jdkits.SysKit;
import cn.zhucongqi.jdkits.ValidateKit;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public final class IPKit {
    private static final String OBTAIN_IP_ERROR = "\u83b7\u53d6IP\u4fe1\u606f\u5931\u8d25";

    public static String getServerIp() {
        String sysType = SysKit.getOSType();
        String ip = OBTAIN_IP_ERROR;
        if ("windows".equals(sysType)) {
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        } else if ("linux".equals(sysType)) {
            ip = IPKit.getIpByEthId("eth0");
        } else if ("macOS".equals(sysType)) {
            ip = IPKit.getIpByEthId("en0");
        }
        return ip;
    }

    private static String getIpByEthId(String ethId) {
        String ip = OBTAIN_IP_ERROR;
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (!ethId.equals(netInterface.getName())) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ipAddress = addresses.nextElement();
                    if (!ValidateKit.isNotNull(ipAddress) || !(ipAddress instanceof Inet4Address)) continue;
                    return ipAddress.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return ip;
    }
}

