/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.jdkits;

import cn.zhucongqi.jdkits.Base64Kit;
import cn.zhucongqi.jdkits.FileKit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public final class ImageKit {
    public static String encodeDataUri(String imageFilePath) throws IOException {
        return ImageKit.encodeDataUri(new File(imageFilePath));
    }

    public static String encodeDataUri(File imageFile) throws IOException {
        String type = FileKit.getFileExtension(imageFile).toLowerCase();
        if ("jpg".equals(type)) {
            type = "jpeg";
        }
        return "data:image/" + type + ";base64," + ImageKit.encodeBase64(imageFile);
    }

    public static String encodeBase64(String imageFilePath) throws IOException {
        return ImageKit.encodeBase64(new File(imageFilePath));
    }

    public static String encodeBase64(File imageFile) throws IOException {
        BufferedImage bi = ImageIO.read(imageFile);
        String type = FileKit.getFileExtension(imageFile).toLowerCase();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, type, byteArrayOutputStream);
        return Base64Kit.encode(byteArrayOutputStream.toByteArray());
    }

    public static File decodeBase64(String imageBase64String, String fileName) throws IOException {
        byte[] decode = Base64Kit.decode(imageBase64String);
        File imageFile = new File(fileName);
        String type = FileKit.getFileExtension(imageFile).toLowerCase();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(decode);
        BufferedImage bi = ImageIO.read(byteArrayInputStream);
        if (!ImageIO.write((RenderedImage)bi, type, imageFile)) {
            return null;
        }
        return imageFile;
    }
}

