/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.jdkits;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

public final class LocalDateTimeKit {
    private static LocalDateTime plus(LocalDateTime dateTime, long plusVal, TemporalUnit unit) {
        LocalDate localDate = dateTime.toLocalDate();
        localDate = localDate.plus(plusVal, unit);
        return LocalDateTime.of(localDate, dateTime.toLocalTime());
    }

    private static LocalDateTime plusHours(LocalDateTime dateTime, long hours) {
        LocalTime localTime = dateTime.toLocalTime();
        localTime = localTime.plusHours(hours);
        return LocalDateTime.of(dateTime.toLocalDate(), localTime);
    }

    private static LocalDateTime plusMinutes(LocalDateTime dateTime, long minutes) {
        LocalTime localTime = dateTime.toLocalTime();
        localTime = localTime.plusMinutes(minutes);
        return LocalDateTime.of(dateTime.toLocalDate(), localTime);
    }

    private static LocalDateTime plus(long plusVal, TemporalUnit unit) {
        return LocalDateTimeKit.plus(LocalDateTime.now(), plusVal, unit);
    }

    private static LocalDateTime plusHours(long hours) {
        return LocalDateTimeKit.plusHours(LocalDateTime.now(), hours);
    }

    private static LocalDateTime plusMinutes(long minutes) {
        return LocalDateTimeKit.plusMinutes(LocalDateTime.now(), minutes);
    }

    public static LocalDateTime afterYears(long years) {
        return LocalDateTimeKit.plus(years, ChronoUnit.YEARS);
    }

    public static LocalDateTime afterMonths(long months) {
        return LocalDateTimeKit.plus(months, ChronoUnit.MONTHS);
    }

    public static LocalDateTime afterWeeks(long weeks) {
        return LocalDateTimeKit.plus(weeks, ChronoUnit.WEEKS);
    }

    public static LocalDateTime afterDays(long days) {
        return LocalDateTimeKit.plus(days, ChronoUnit.DAYS);
    }

    public static LocalDateTime afterHours(long hours) {
        return LocalDateTimeKit.plusHours(hours);
    }

    public static LocalDateTime afterMinutes(long minutes) {
        return LocalDateTimeKit.plusMinutes(minutes);
    }

    public static LocalDateTime beforeYears(long years) {
        return LocalDateTimeKit.plus(-years, ChronoUnit.YEARS);
    }

    public static LocalDateTime beforeMonths(long months) {
        return LocalDateTimeKit.plus(-months, ChronoUnit.MONTHS);
    }

    public static LocalDateTime beforeWeeks(long weeks) {
        return LocalDateTimeKit.plus(-weeks, ChronoUnit.WEEKS);
    }

    public static LocalDateTime beforeDays(long days) {
        return LocalDateTimeKit.plus(-days, ChronoUnit.DAYS);
    }

    public static LocalDateTime beforeHours(long hours) {
        return LocalDateTimeKit.plusHours(-hours);
    }

    public static LocalDateTime beforeMinutes(long minutes) {
        return LocalDateTimeKit.plusMinutes(-minutes);
    }

    public static LocalDateTime afterYears(LocalDateTime dateTime, long years) {
        return LocalDateTimeKit.plus(dateTime, years, ChronoUnit.YEARS);
    }

    public static LocalDateTime afterMonths(LocalDateTime dateTime, long months) {
        return LocalDateTimeKit.plus(dateTime, months, ChronoUnit.MONTHS);
    }

    public static LocalDateTime afterWeeks(LocalDateTime dateTime, long weeks) {
        return LocalDateTimeKit.plus(dateTime, weeks, ChronoUnit.WEEKS);
    }

    public static LocalDateTime afterDays(LocalDateTime dateTime, long days) {
        return LocalDateTimeKit.plus(dateTime, days, ChronoUnit.DAYS);
    }

    public static LocalDateTime afterHours(LocalDateTime dateTime, long hours) {
        return LocalDateTimeKit.plusHours(dateTime, hours);
    }

    public static LocalDateTime afterMinutes(LocalDateTime dateTime, long minutes) {
        return LocalDateTimeKit.plusMinutes(dateTime, minutes);
    }

    public static LocalDateTime beforeYears(LocalDateTime dateTime, long years) {
        return LocalDateTimeKit.plus(dateTime, -years, ChronoUnit.YEARS);
    }

    public static LocalDateTime beforeMonths(LocalDateTime dateTime, long months) {
        return LocalDateTimeKit.plus(dateTime, -months, ChronoUnit.MONTHS);
    }

    public static LocalDateTime beforeWeeks(LocalDateTime dateTime, long weeks) {
        return LocalDateTimeKit.plus(dateTime, -weeks, ChronoUnit.WEEKS);
    }

    public static LocalDateTime beforeDays(LocalDateTime dateTime, long days) {
        return LocalDateTimeKit.plus(dateTime, -days, ChronoUnit.DAYS);
    }

    public static LocalDateTime beforeHours(LocalDateTime dateTime, long hours) {
        return LocalDateTimeKit.plusHours(dateTime, -hours);
    }

    public static LocalDateTime beforeMinutes(LocalDateTime dateTime, long minutes) {
        return LocalDateTimeKit.plusMinutes(dateTime, -minutes);
    }
}

