/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.jdkits;

import cn.zhucongqi.jdkits.CompressKit;
import cn.zhucongqi.jdkits.JacksonKit;
import cn.zhucongqi.jdkits.SerializationKit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;

public final class ObjectKit {
    public static byte[] toByteArray(Object obj) {
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bytes;
    }

    public static <T> T toObject(byte[] bytes) {
        Object obj = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            obj = ois.readObject();
            ois.close();
            bis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return (T)obj;
    }

    public static byte[] toCompressByteArray(Object obj) {
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return CompressKit.compress(bytes);
    }

    public static <T> T toDecompressObject(byte[] bytes) {
        Object obj = null;
        try {
            byte[] decompress = CompressKit.decompress(bytes);
            ByteArrayInputStream bis = new ByteArrayInputStream(decompress);
            ObjectInputStream ois = new ObjectInputStream(bis);
            obj = ois.readObject();
            ois.close();
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)obj;
    }

    public static byte[] toCompressByteArray(Object obj, String password) {
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return CompressKit.compress(bytes, password);
    }

    public static <T> T toDecompressObject(byte[] bytes, String password) {
        Object obj = null;
        try {
            byte[] decompress = CompressKit.decompress(bytes, password);
            ByteArrayInputStream bis = new ByteArrayInputStream(decompress);
            ObjectInputStream ois = new ObjectInputStream(bis);
            obj = ois.readObject();
            ois.close();
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)obj;
    }

    public static Map toMap(Object obj) {
        return JacksonKit.toMap(JacksonKit.toJson(obj));
    }

    public <T extends Serializable> T clone(T obj) {
        return SerializationKit.clone(obj);
    }
}

