/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.openingo.jdkits.AssertKit;
import org.openingo.jdkits.ValidateKit;

public final class NumberKit {
    private NumberKit() {
    }

    public static Boolean isByte(Object obj) {
        return obj instanceof Byte;
    }

    public static Boolean isInt(Object obj) {
        return obj instanceof Integer;
    }

    public static Boolean isLong(Object obj) {
        return obj instanceof Long;
    }

    public static Boolean isShort(Object obj) {
        return obj instanceof Short;
    }

    public static Boolean isDouble(Object obj) {
        return obj instanceof Double;
    }

    public static Boolean isFloat(Object obj) {
        return obj instanceof Float;
    }

    public static Boolean isBigDecimal(Object obj) {
        return obj instanceof BigDecimal;
    }

    public static Boolean isBigInteger(Object obj) {
        return obj instanceof BigInteger;
    }

    public static Boolean isZero(Object obj) {
        if (ValidateKit.isNull(obj)) {
            return false;
        }
        if ((NumberKit.isInt(obj).booleanValue() || NumberKit.isByte(obj).booleanValue() || NumberKit.isShort(obj).booleanValue() || NumberKit.isLong(obj).booleanValue()) && (Integer)obj == 0) {
            return true;
        }
        if ((NumberKit.isFloat(obj).booleanValue() || NumberKit.isDouble(obj).booleanValue()) && (Double)obj == 0.0) {
            return true;
        }
        if (NumberKit.isBigInteger(obj).booleanValue() && BigInteger.ZERO.equals(obj)) {
            return true;
        }
        if (NumberKit.isBigDecimal(obj).booleanValue() && BigDecimal.ZERO.equals(obj)) {
            return true;
        }
        return false;
    }

    public static String toHex(Object obj) {
        AssertKit.notNull(obj, "obj\u4e0d\u80fd\u4e3anull.");
        String hexString = "";
        if (NumberKit.isInt(obj).booleanValue() || NumberKit.isShort(obj).booleanValue() || NumberKit.isByte(obj).booleanValue()) {
            hexString = Integer.toHexString((Integer)obj);
        }
        if (NumberKit.isLong(obj).booleanValue()) {
            hexString = Long.toHexString((Long)obj);
        }
        if (NumberKit.isFloat(obj).booleanValue() || NumberKit.isDouble(obj).booleanValue()) {
            hexString = Double.toHexString((Double)obj);
        }
        if (NumberKit.isBigInteger(obj).booleanValue()) {
            hexString = ((BigInteger)obj).toString(16);
        }
        if (NumberKit.isBigDecimal(obj).booleanValue()) {
            hexString = ((BigDecimal)obj).toBigInteger().toString(16);
        }
        return hexString;
    }
}

