/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.openingo.jdkits.AesKit;
import org.openingo.jdkits.HashKit;

public final class CompressKit {
    private CompressKit() {
    }

    public static void zipFile(String inputFile, String outputFile) throws Exception {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outputFile));
        out.setLevel(9);
        BufferedOutputStream bos = new BufferedOutputStream(out);
        File input = new File(inputFile);
        CompressKit.zipFile(out, bos, input, null);
        bos.close();
        out.closeEntry();
        out.close();
    }

    private static void zipFile(ZipOutputStream out, BufferedOutputStream bos, File input, String name) throws IOException {
        if (name == null) {
            name = input.getName();
        }
        if (input.isDirectory()) {
            File[] flist = input.listFiles();
            if (flist.length == 0) {
                out.putNextEntry(new ZipEntry(name + "/"));
            } else {
                for (int i = 0; i < flist.length; ++i) {
                    CompressKit.zipFile(out, bos, flist[i], name + "/" + flist[i].getName());
                }
            }
        } else {
            out.putNextEntry(new ZipEntry(name));
            FileInputStream fos = new FileInputStream(input);
            BufferedInputStream bis = new BufferedInputStream(fos);
            int len = -1;
            byte[] buf = new byte[1024];
            while ((len = bis.read(buf)) != -1) {
                bos.write(buf, 0, len);
            }
            bis.close();
            fos.close();
        }
    }

    public static void unZipFile(String inputFile, String destDirPath) throws Exception {
        File srcFile = new File(inputFile);
        if (!srcFile.exists()) {
            throw new Exception(srcFile.getPath() + "\u6240\u6307\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        ZipInputStream zIn = new ZipInputStream(new FileInputStream(srcFile));
        ZipEntry entry = null;
        File file = null;
        while ((entry = zIn.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            file = new File(destDirPath, entry.getName());
            if (!file.exists()) {
                new File(file.getParent()).mkdirs();
            }
            FileOutputStream out = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(out);
            int len = -1;
            byte[] buf = new byte[1024];
            while ((len = zIn.read(buf)) != -1) {
                bos.write(buf, 0, len);
            }
            bos.close();
            ((OutputStream)out).close();
        }
    }

    public static byte[] compress(byte[] compressSource, boolean GZIPFormat) {
        Deflater compressor = new Deflater(9, GZIPFormat);
        compressor.setInput(compressSource);
        compressor.finish();
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        byte[] readBuffer = new byte[1024];
        int readCount = 0;
        while (!compressor.finished()) {
            readCount = compressor.deflate(readBuffer);
            if (readCount <= 0) continue;
            bao.write(readBuffer, 0, readCount);
        }
        compressor.end();
        return bao.toByteArray();
    }

    public static byte[] decompress(byte[] decompressSource, boolean GZIPFormat) throws Exception {
        Inflater decompressor = new Inflater(GZIPFormat);
        decompressor.setInput(decompressSource);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        byte[] readBuffer = new byte[1024];
        int readCount = 0;
        while (!decompressor.finished()) {
            readCount = decompressor.inflate(readBuffer);
            if (readCount <= 0) continue;
            bao.write(readBuffer, 0, readCount);
        }
        decompressor.end();
        return bao.toByteArray();
    }

    public static byte[] compress(String compressSource) {
        return CompressKit.compress(compressSource.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] compress(byte[] compressSource) {
        return CompressKit.compress(compressSource, true);
    }

    public static byte[] compress(String compressSource, String password) {
        return CompressKit.compress(compressSource.getBytes(StandardCharsets.UTF_8), password);
    }

    public static byte[] compress(byte[] compressSource, String password) {
        return AesKit.encrypt(CompressKit.compress(compressSource, true), HashKit.md5(password));
    }

    public static byte[] decompress(byte[] decompressSource) throws Exception {
        return CompressKit.decompress(decompressSource, true);
    }

    public static byte[] decompress(byte[] decompressSource, String password) throws Exception {
        return CompressKit.decompress(AesKit.decrypt(decompressSource, HashKit.md5(password)), true);
    }
}

