/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openingo.jdkits.StrKit;

public final class JavaKeywordKit {
    private String[] keywordArray = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "strictfp", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
    private Set<String> set = new HashSet<String>();
    public static final JavaKeywordKit javaKeywordKit = JavaKeywordKit.createSharedInstance();

    private static JavaKeywordKit createSharedInstance() {
        JavaKeywordKit jk = new JavaKeywordKit();
        jk.set = Collections.unmodifiableSet(jk.set);
        return jk;
    }

    private JavaKeywordKit() {
        for (String keyword : this.keywordArray) {
            this.set.add(keyword);
        }
    }

    public JavaKeywordKit addKeyword(String keyword) {
        if (StrKit.notBlank(keyword)) {
            this.set.add(keyword);
        }
        return this;
    }

    public JavaKeywordKit removeKeyword(String keyword) {
        this.set.remove(keyword);
        return this;
    }

    public boolean contains(String str) {
        return this.set.contains(str);
    }
}

