/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.openingo.jdkits.CompressKit;
import org.openingo.jdkits.JacksonKit;
import org.openingo.jdkits.SerializationKit;
import org.openingo.jdkits.StrKit;
import org.openingo.jdkits.ValidateKit;

public final class ObjectKit {
    private ObjectKit() {
    }

    public static byte[] toByteArray(Object obj) {
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bytes;
    }

    public static <T> T toObject(byte[] bytes) {
        Object obj = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            obj = ois.readObject();
            ois.close();
            bis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return (T)obj;
    }

    public static byte[] toCompressByteArray(Object obj) {
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return CompressKit.compress(bytes);
    }

    public static <T> T toDecompressObject(byte[] bytes) {
        Object obj = null;
        try {
            byte[] decompress = CompressKit.decompress(bytes);
            ByteArrayInputStream bis = new ByteArrayInputStream(decompress);
            ObjectInputStream ois = new ObjectInputStream(bis);
            obj = ois.readObject();
            ois.close();
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)obj;
    }

    public static byte[] toCompressByteArray(Object obj, String password) {
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return CompressKit.compress(bytes, password);
    }

    public static <T> T toDecompressObject(byte[] bytes, String password) {
        Object obj = null;
        try {
            byte[] decompress = CompressKit.decompress(bytes, password);
            ByteArrayInputStream bis = new ByteArrayInputStream(decompress);
            ObjectInputStream ois = new ObjectInputStream(bis);
            obj = ois.readObject();
            ois.close();
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)obj;
    }

    public static Map toMap(Object obj) {
        return JacksonKit.toMap(JacksonKit.toJson(obj));
    }

    public <T extends Serializable> T clone(T obj) {
        return SerializationKit.clone(obj);
    }

    public static Integer toInteger(Object obj) {
        if (ValidateKit.isNull(obj)) {
            return 0;
        }
        return StrKit.toInteger(obj.toString());
    }

    public static Long toLong(Object obj) {
        if (ValidateKit.isNull(obj)) {
            return 0L;
        }
        return StrKit.toLong(obj.toString());
    }

    public static Double toDouble(Object obj) {
        if (ValidateKit.isNull(obj)) {
            return 0.0;
        }
        return StrKit.toDouble(obj.toString());
    }

    public static Float toFloat(Object obj) {
        if (ValidateKit.isNull(obj)) {
            return Float.valueOf(0.0f);
        }
        return StrKit.toFloat(obj.toString());
    }
}

