/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits;

import org.openingo.jdkits.ExceptionKit;
import org.openingo.jdkits.ValidateKit;

public final class AssertKit {
    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            ExceptionKit.throwRuntimeException(message);
        }
    }

    public static void isFalse(boolean expression, String message) {
        if (expression) {
            ExceptionKit.throwRuntimeException(message);
        }
    }

    public static void isNull(Object object, String message) {
        if (ValidateKit.isNotNull(object)) {
            ExceptionKit.throwIllegalArgumentException(message);
        }
    }

    public static void notNull(Object object, String message) {
        if (ValidateKit.isNull(object)) {
            ExceptionKit.throwNullPointerException(message);
        }
    }

    public static void isEmpty(Object[] array, String message) {
        if (ValidateKit.isNotEmpty(array)) {
            ExceptionKit.throwIllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array, String message) {
        if (ValidateKit.isEmpty(array)) {
            ExceptionKit.throwNullPointerException(message);
        }
    }

    public static void isEqual(Object a, Object b, String message) {
        if (ValidateKit.isNotEqual(a, b)) {
            ExceptionKit.throwIllegalArgumentException(message);
        }
    }

    public static void isNotEqual(Object a, Object b, String message) {
        if (ValidateKit.isEqual(a, b)) {
            ExceptionKit.throwIllegalArgumentException(message);
        }
    }
}

