/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openingo.jdkits.ListKit;
import org.openingo.jdkits.ValidateKit;

public final class FastJsonKit {
    public static String toJson(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public static String toJson(Object obj, String datePattern) {
        return JSON.toJSONStringWithDateFormat((Object)obj, (String)datePattern, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.DisableCircularReferenceDetect});
    }

    public static <T> T toObj(String json, Class<T> clazz) {
        return (T)JSON.parseObject((String)json, clazz);
    }

    public static <K, V> Map<K, V> toMap(String json) {
        HashMap aMap = FastJsonKit.toObj(json, Map.class);
        if (ValidateKit.isNull(aMap)) {
            aMap = new HashMap();
        }
        return aMap;
    }

    public static <K, V> Map<K, V> toMap(Object obj) {
        return FastJsonKit.toMap(FastJsonKit.toJson(obj));
    }

    public static <T> List<T> toList(String json, Class<T> clazz) {
        return ListKit.emptyArrayListIfNull(JSONArray.parseArray((String)json, clazz));
    }

    public static <T> List<T[]> to2DList(String json, Class<T[]> clazz) {
        return ListKit.emptyArrayListIfNull(JSONArray.parseArray((String)json, clazz));
    }

    public static <K> List<Map<K, Object>> toMapList(String json) {
        return ListKit.emptyArrayListIfNull(FastJsonKit.toObj(json, List.class));
    }
}

