/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits;

import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.openingo.jdkits.Base64Kit;
import org.openingo.jdkits.RandomKit;
import org.openingo.jdkits.ValidateKit;

public final class RSAKit {
    private static final String KEY_ALGORITHM_RSA = "RSA";
    private static final String RSA_PUBLIC_KEY = "RSAPublicKey";
    private static final String RSA_PRIVATE_KEY = "RSAPrivateKey";
    private static final int KEY_SIZE = 1024;
    private static Map<String, Key> keysStore;

    private static void init(byte[] seed) throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM_RSA);
        keyPairGen.initialize(1024, new SecureRandom(seed));
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        keysStore = new HashMap<String, Key>(2);
        keysStore.put(RSA_PUBLIC_KEY, publicKey);
        keysStore.put(RSA_PRIVATE_KEY, privateKey);
    }

    private static void initKeysStoreIfNeed() throws Exception {
        if (ValidateKit.isNull(keysStore)) {
            RSAKit.init();
        }
    }

    public static byte[] encrypt(byte[] data, Key key) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, key);
        int blockSize = cipher.getBlockSize();
        if (blockSize > 0) {
            int outputSize = cipher.getOutputSize(data.length);
            int leavedSize = data.length % blockSize;
            int blocksSize = leavedSize != 0 ? data.length / blockSize + 1 : data.length / blockSize;
            byte[] raw = new byte[outputSize * blocksSize];
            int i = 0;
            int remainSize = 0;
            while ((remainSize = data.length - i * blockSize) > 0) {
                int inputLen = Math.min(remainSize, blockSize);
                cipher.doFinal(data, i * blockSize, inputLen, raw, i * outputSize);
                ++i;
            }
            return raw;
        }
        return cipher.doFinal(data);
    }

    public static byte[] decrypt(byte[] data, Key key) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, key);
        int blockSize = cipher.getBlockSize();
        if (blockSize > 0) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(64);
            int j = 0;
            while (data.length - j * blockSize > 0) {
                bout.write(cipher.doFinal(data, j * blockSize, blockSize));
                ++j;
            }
            return bout.toByteArray();
        }
        return cipher.doFinal(data);
    }

    public static void init(String seed) throws Exception {
        RSAKit.init(seed.getBytes());
    }

    public static void init() throws Exception {
        RSAKit.init(RandomKit.uuidStr());
    }

    public static Key getPrivateKey() throws Exception {
        RSAKit.initKeysStoreIfNeed();
        return keysStore.get(RSA_PRIVATE_KEY);
    }

    public static byte[] getPrivateKeyByte() throws Exception {
        return RSAKit.getPrivateKey().getEncoded();
    }

    public static Key getPublicKey() throws Exception {
        RSAKit.initKeysStoreIfNeed();
        return keysStore.get(RSA_PUBLIC_KEY);
    }

    public static byte[] getPublicKeyByte() throws Exception {
        return RSAKit.getPublicKey().getEncoded();
    }

    public static PublicKey getPublicKey(String base64EncodedKey) throws Exception {
        X509EncodedKeySpec x509 = new X509EncodedKeySpec(Base64Kit.decode(base64EncodedKey));
        KeyFactory kf = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
        return kf.generatePublic(x509);
    }

    public static PrivateKey getPrivateKey(String base64EncodedKey) throws Exception {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64Kit.decode(base64EncodedKey));
        KeyFactory kf = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
        return kf.generatePrivate(pkcs8EncodedKeySpec);
    }

    public static byte[] encryptByPublicKey(byte[] data, byte[] key) throws Exception {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(key);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        return RSAKit.encrypt(data, publicKey);
    }

    public static byte[] encryptByPublicKey(byte[] data) throws Exception {
        return RSAKit.encrypt(data, RSAKit.getPublicKey());
    }

    public static byte[] encryptByPrivateKey(byte[] data, byte[] key) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(key);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        return RSAKit.encrypt(data, privateKey);
    }

    public static byte[] encryptByPrivateKey(byte[] data) throws Exception {
        return RSAKit.encrypt(data, RSAKit.getPrivateKey());
    }

    public static byte[] decryptByPublicKey(byte[] data, byte[] key) throws Exception {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(key);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        return RSAKit.decrypt(data, publicKey);
    }

    public static byte[] decryptByPublicKey(byte[] data) throws Exception {
        return RSAKit.decrypt(data, RSAKit.getPublicKey());
    }

    public static byte[] decryptByPrivateKey(byte[] data, byte[] key) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(key);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM_RSA);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        return RSAKit.decrypt(data, privateKey);
    }

    public static byte[] decryptByPrivateKey(byte[] data) throws Exception {
        return RSAKit.decrypt(data, RSAKit.getPrivateKey());
    }
}

