/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.http;

import java.util.HashMap;
import org.openingo.jdkits.ValidateKit;

public final class RespData
extends HashMap<String, Object> {
    private static final long serialVersionUID = 7348797463704162367L;
    private static final String REQUEST_DATA_INVALID = "request_data_invalid!";
    private static final String RESPONSE_DATA_INVALID = "response_data_invalid!";

    public static RespData invalidReq() {
        return RespData.failure(REQUEST_DATA_INVALID);
    }

    public static RespData invalidResp() {
        return RespData.failure(RESPONSE_DATA_INVALID);
    }

    public static RespData ret(RespData data) {
        if (ValidateKit.isNull(data)) {
            return RespData.invalidResp();
        }
        return data;
    }

    public static RespData success() {
        return new RespData(Config.SUCCESS_SC, Config.SUCCESS_SM);
    }

    public static RespData success(Object data) {
        return new RespData(Config.SUCCESS_SC, Config.SUCCESS_SM, data);
    }

    public static RespData failure(String sm) {
        return new RespData(Config.FAILURE_SC, sm);
    }

    private RespData() {
    }

    private RespData(String sc, String sm) {
        if (!Config.SM_ONLY) {
            this.put(Config.SC_KEY, sc);
        }
        this.put(Config.SM_KEY, sm);
    }

    private RespData(String sc, String sm, Object data) {
        this(sc, sm);
        this.put(Config.DATA_KEY, data);
    }

    public String getSc() {
        if (Config.SM_ONLY) {
            return "unset";
        }
        return this.get(Config.SC_KEY).toString();
    }

    public String getSm() {
        return this.get(Config.SM_KEY).toString();
    }

    public <T> T getData() {
        return (T)this.get(Config.DATA_KEY);
    }

    public static final class Config {
        public static String SC_KEY = "sc";
        public static String SM_KEY = "sm";
        public static String DATA_KEY = "data";
        public static String SUCCESS_SC = "success";
        public static String SUCCESS_SM = "response successful";
        public static String FAILURE_SC = "failure";
        public static boolean SM_ONLY = false;
        public static final String UNSET_SC = "unset";
    }
}

