/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.image;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.openingo.jdkits.coding.Base64Kit;
import org.openingo.jdkits.exeption.ExceptionKit;
import org.openingo.jdkits.file.FileKit;
import org.openingo.jdkits.validate.ValidateKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageKit {
    private static Logger log = LoggerFactory.getLogger(ImageKit.class);
    private static String DEFAULT_PREFIX = "thumb_";
    private static Boolean DEFAULT_FORCE = false;

    private ImageKit() {
    }

    public static String encodeDataUri(String imageFilePath) throws IOException {
        return ImageKit.encodeDataUri(new File(imageFilePath));
    }

    public static String encodeDataUri(File imageFile) throws IOException {
        String type = FileKit.getFileExtension(imageFile).toLowerCase();
        if ("jpg".equals(type)) {
            type = "jpeg";
        }
        return "data:image/" + type + ";base64," + ImageKit.encodeBase64(imageFile);
    }

    public static String encodeBase64(String imageFilePath) throws IOException {
        return ImageKit.encodeBase64(new File(imageFilePath));
    }

    public static String encodeBase64(File imageFile) throws IOException {
        BufferedImage bi = ImageIO.read(imageFile);
        String type = FileKit.getFileExtension(imageFile).toLowerCase();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, type, byteArrayOutputStream);
        return Base64Kit.encode(byteArrayOutputStream.toByteArray());
    }

    public static File decodeBase64(String imageBase64String, String fileName) throws IOException {
        byte[] decode = Base64Kit.decode(imageBase64String);
        File imageFile = new File(fileName);
        String type = FileKit.getFileExtension(imageFile).toLowerCase();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(decode);
        BufferedImage bi = ImageIO.read(byteArrayInputStream);
        if (!ImageIO.write((RenderedImage)bi, type, imageFile)) {
            return null;
        }
        return imageFile;
    }

    public static String makeThumbnailImage(String imagePath, int w, int h) {
        return ImageKit.makeThumbnailImage(imagePath, w, h, DEFAULT_PREFIX, DEFAULT_FORCE);
    }

    public static String makeThumbnailImage(String imagePath, int w, int h, String prefix, boolean force) {
        File imgFile = new File(imagePath);
        String newPath = "";
        if (!imgFile.exists()) {
            log.warn("the image is not exist.");
        }
        try {
            String types = Arrays.toString(ImageIO.getReaderFormatNames());
            String suffix = null;
            if (imgFile.getName().contains(".")) {
                suffix = imgFile.getName().substring(imgFile.getName().lastIndexOf(".") + 1);
            }
            if (suffix == null || !types.toLowerCase().contains(suffix.toLowerCase())) {
                log.error("Sorry, the image suffix is illegal. the standard image suffix is {}." + types);
                return "";
            }
            log.debug("target image's size, width:{}, height:{}.", (Object)w, (Object)h);
            BufferedImage img = ImageIO.read(imgFile);
            if (!force) {
                int height;
                int width = ((Image)img).getWidth(null);
                if ((double)width * 1.0 / (double)w < (double)(height = ((Image)img).getHeight(null)) * 1.0 / (double)h) {
                    if (width > w) {
                        h = Integer.parseInt(new DecimalFormat("0").format((double)(height * w) / ((double)width * 1.0)));
                        log.debug("change image's height, width:{}, height:{}.", (Object)w, (Object)h);
                    }
                } else if (height > h) {
                    w = Integer.parseInt(new DecimalFormat("0").format((double)(width * h) / ((double)height * 1.0)));
                    log.debug("change image's width, width:{}, height:{}.", (Object)w, (Object)h);
                }
            }
            BufferedImage bi = new BufferedImage(w, h, 1);
            Graphics g = bi.getGraphics();
            g.drawImage(img, 0, 0, w, h, Color.LIGHT_GRAY, null);
            g.dispose();
            String p = imgFile.getPath();
            newPath = p.substring(0, p.lastIndexOf(File.separator)) + File.separator + prefix + imgFile.getName();
            ImageIO.write((RenderedImage)bi, suffix, new File(newPath));
        }
        catch (IOException e) {
            log.error("generate thumbnail image failed.", (Throwable)e);
        }
        return newPath;
    }

    public static String reduceImage(String srcImagePath, String targetImagePath, int targetWidth, int targetHeight, Float rate) throws Exception {
        String outFilePath = "";
        File srcImageFile = new File(srcImagePath);
        String fileName = srcImageFile.getName();
        if (!srcImageFile.exists()) {
            ExceptionKit.throwRuntimeException("file is not exists.");
        }
        String types = Arrays.toString(ImageIO.getReaderFormatNames());
        String suffix = null;
        if (fileName.contains(".")) {
            suffix = srcImageFile.getName().substring(fileName.lastIndexOf(".") + 1);
        }
        if (suffix == null || !types.toLowerCase().contains(suffix.toLowerCase())) {
            log.error("Sorry, the image suffix is illegal. the standard image suffix is {}." + types);
        }
        if (rate != null && rate.floatValue() > 0.0f) {
            int height = ImageKit.getImageHeight(srcImageFile);
            int width = ImageKit.getImageWidth(srcImageFile);
            if (height == 0 || width == 0) {
                ExceptionKit.throwIllegalArgumentException("\u8f93\u5165\u53c2\u6570\u9519\u8bef");
            } else {
                targetWidth = (int)((float)width * rate.floatValue());
                targetHeight = (int)((float)height * rate.floatValue());
            }
        }
        BufferedImage src = ImageIO.read(srcImageFile);
        BufferedImage tag = new BufferedImage(targetWidth, targetHeight, 1);
        Graphics g = tag.getGraphics();
        g.drawImage(src.getScaledInstance(targetWidth, targetHeight, 4), 0, 0, null);
        g.dispose();
        if (!targetImagePath.endsWith(File.separator)) {
            targetImagePath = targetImagePath + File.separator;
        }
        outFilePath = targetImagePath + "compress_" + fileName;
        ImageIO.write((RenderedImage)tag, suffix, new File(outFilePath));
        return targetImagePath + "compress_" + fileName;
    }

    public static String reduceImage(String srcImagePath, String targetImagePath, Float rate) throws Exception {
        return ImageKit.reduceImage(srcImagePath, targetImagePath, 0, 0, rate);
    }

    public static String reduceImage(String srcImagePath, String targetImagePath, int targetWidth, int targetHeight) throws Exception {
        return ImageKit.reduceImage(srcImagePath, targetImagePath, targetWidth, targetHeight, Float.valueOf(0.0f));
    }

    private static BufferedImage getImageBufferedImage(FileInputStream imageFileInputStream) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(imageFileInputStream);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return bufferedImage;
    }

    private static BufferedImage getImageBufferedImage(File imageFile) {
        FileInputStream imageFileInputStream = null;
        try {
            imageFileInputStream = new FileInputStream(imageFile);
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage());
        }
        return ImageKit.getImageBufferedImage(imageFileInputStream);
    }

    public static int getImageWidth(FileInputStream fileInputStream) {
        BufferedImage bufferedImage = ImageKit.getImageBufferedImage(fileInputStream);
        int ret = -1;
        if (ValidateKit.isNotNull(bufferedImage)) {
            ret = bufferedImage.getWidth();
        }
        return ret;
    }

    public static int getImageWidth(File imageFile) {
        BufferedImage bufferedImage = ImageKit.getImageBufferedImage(imageFile);
        int ret = -1;
        if (ValidateKit.isNotNull(bufferedImage)) {
            ret = bufferedImage.getWidth();
        }
        return ret;
    }

    public static int getImageHeight(FileInputStream fileInputStream) {
        BufferedImage bufferedImage = ImageKit.getImageBufferedImage(fileInputStream);
        int ret = -1;
        if (ValidateKit.isNotNull(bufferedImage)) {
            ret = bufferedImage.getHeight();
        }
        return ret;
    }

    public static int getImageHeight(File imageFile) {
        BufferedImage bufferedImage = ImageKit.getImageBufferedImage(imageFile);
        int ret = -1;
        if (ValidateKit.isNotNull(bufferedImage)) {
            ret = bufferedImage.getHeight();
        }
        return ret;
    }
}

