/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.openingo.jdkits.exeption.ExceptionKit;
import org.openingo.jdkits.validate.AssertKit;

public final class ClassKit {
    private static final char PACKAGE_SEPARATOR = '.';
    private static final List<String> PROXY_CLASS_NAMES = Arrays.asList("net.sf.cglib.proxy.Factory", "org.springframework.cglib.proxy.Factory", "javassist.util.proxy.ProxyObject", "org.apache.ibatis.javassist.util.proxy.ProxyObject");

    private ClassKit() {
    }

    public static boolean isBoolean(Class<?> type) {
        return type == Boolean.TYPE || Boolean.class == type;
    }

    public static boolean isProxy(Class<?> clazz) {
        if (clazz != null) {
            for (Class<?> cls : clazz.getInterfaces()) {
                if (!PROXY_CLASS_NAMES.contains(cls.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static Class<?> getUserClass(Class<?> clazz) {
        return ClassKit.isProxy(clazz) ? clazz.getSuperclass() : clazz;
    }

    public static Class<?> getUserClass(Object object) {
        AssertKit.notNull(object, "Error: Instance must not be null");
        return ClassKit.getUserClass(object.getClass());
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            ExceptionKit.throwRuntimeException(String.format("\u5b9e\u4f8b\u5316\u5bf9\u8c61\u65f6\u51fa\u73b0\u9519\u8bef,\u8bf7\u5c1d\u8bd5\u7ed9 %s \u6dfb\u52a0\u65e0\u53c2\u7684\u6784\u9020\u65b9\u6cd5 %s", e, clazz.getName()));
            return null;
        }
    }

    public static Class<?> toClassConfident(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            ExceptionKit.throwRuntimeException("\u627e\u4e0d\u5230\u6307\u5b9a\u7684class\uff01\u8bf7\u4ec5\u5728\u660e\u786e\u786e\u5b9a\u4f1a\u6709 class \u7684\u65f6\u5019\uff0c\u8c03\u7528\u8be5\u65b9\u6cd5" + e);
            return null;
        }
    }

    public static String getPackageName(Class<?> clazz) {
        AssertKit.notNull(clazz, "Class must not be null");
        return ClassKit.getPackageName(clazz.getName());
    }

    public static String getPackageName(String fqClassName) {
        AssertKit.notNull(fqClassName, "Class name must not be null");
        int lastDotIndex = fqClassName.lastIndexOf(46);
        return lastDotIndex != -1 ? fqClassName.substring(0, lastDotIndex) : "";
    }
}

