/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.sys;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.openingo.jdkits.sys.SysKit;
import org.openingo.jdkits.validate.ValidateKit;

public final class IPKit {
    private static final String OBTAIN_IP_ERROR = "\u83b7\u53d6IP\u4fe1\u606f\u5931\u8d25";
    private static final String LOCALHOST = "127.0.0.1";

    private IPKit() {
    }

    public static String getServerIp() {
        String sysType = SysKit.getOSType();
        String ip = OBTAIN_IP_ERROR;
        if ("windows".equals(sysType)) {
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        } else if ("linux".equals(sysType)) {
            ip = IPKit.getIpByEthId("eth0");
        } else if ("macOS".equals(sysType)) {
            ip = IPKit.getIpByEthId("en0");
        }
        return ip;
    }

    private static String getIpByEthId(String ethId) {
        String ip = OBTAIN_IP_ERROR;
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (!ethId.equals(netInterface.getName())) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ipAddress = addresses.nextElement();
                    if (!ValidateKit.isNotNull(ipAddress) || !(ipAddress instanceof Inet4Address)) continue;
                    return ipAddress.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return ip;
    }

    public static String getRequestIP(HttpServletRequest request) {
        String unknown = "unknown";
        String ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || unknown.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || unknown.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || unknown.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || unknown.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ipAddress == null || ipAddress.length() == 0 || unknown.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getRemoteAddr();
        }
        if (ipAddress != null && ipAddress.indexOf(",") != -1) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(",")).trim();
        }
        if ("0:0:0:0:0:0:0:1".equals(ipAddress)) {
            ipAddress = LOCALHOST;
        }
        return ipAddress;
    }
}

