/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.lang;

import java.util.List;
import java.util.UUID;
import org.openingo.jdkits.hash.HashKit;
import org.openingo.jdkits.lang.StringPoolKit;
import org.openingo.jdkits.validate.ValidateKit;

public final class StrKit
implements StringPoolKit {
    private StrKit() {
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        if (len == 0) {
            return true;
        }
        block3: for (int i = 0; i < len; ++i) {
            switch (str.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean notBlank(String str) {
        return !StrKit.isBlank(str);
    }

    public static boolean notBlank(String ... strings) {
        if (strings == null || strings.length == 0) {
            return false;
        }
        for (String str : strings) {
            if (!StrKit.isBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean notNull(Object ... paras) {
        if (paras == null) {
            return false;
        }
        for (Object obj : paras) {
            if (obj != null) continue;
            return false;
        }
        return true;
    }

    public static String defaultIfBlank(String str, String defaultValue) {
        return StrKit.isBlank(str) ? defaultValue : str;
    }

    public static String toCamelCase(String stringWithUnderline) {
        if (stringWithUnderline.indexOf(95) == -1) {
            return stringWithUnderline;
        }
        stringWithUnderline = stringWithUnderline.toLowerCase();
        char[] fromArray = stringWithUnderline.toCharArray();
        char[] toArray = new char[fromArray.length];
        int j = 0;
        for (int i = 0; i < fromArray.length; ++i) {
            if (fromArray[i] == '_') {
                if (++i >= fromArray.length) continue;
                toArray[j++] = Character.toUpperCase(fromArray[i]);
                continue;
            }
            toArray[j++] = fromArray[i];
        }
        return new String(toArray, 0, j);
    }

    public static String join(String[] stringArray) {
        StringBuilder sb = new StringBuilder();
        for (String s : stringArray) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String join(String[] stringArray, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(stringArray[i]);
        }
        return sb.toString();
    }

    public static String join(List<String> list, String separator) {
        StringBuilder sb = new StringBuilder();
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(list.get(i));
        }
        return sb.toString();
    }

    public static boolean slowEquals(String a, String b) {
        byte[] aBytes = a != null ? a.getBytes() : null;
        byte[] bBytes = b != null ? b.getBytes() : null;
        return HashKit.slowEquals(aBytes, bBytes);
    }

    public static boolean equals(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    public static String getRandomUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static Integer toInteger(String obj) {
        return Integer.valueOf(obj);
    }

    public static Long toLong(String obj) {
        return Long.valueOf(obj);
    }

    public static Double toDouble(String obj) {
        return Double.valueOf(obj);
    }

    public static Float toFloat(String obj) {
        return Float.valueOf(obj);
    }

    public static boolean equalsAny(CharSequence string, CharSequence ... searchStrings) {
        if (ValidateKit.isNotEmpty(searchStrings)) {
            for (CharSequence next : searchStrings) {
                if (!StrKit.equals(string, next)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        int length = cs1.length();
        for (int i = 0; i < length; ++i) {
            if (cs1.charAt(i) == cs2.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

