/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.image;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.OutputStream;
import java.util.HashMap;
import org.openingo.jdkits.lang.StrKit;

public final class QrCodeKit {
    private QrCodeKit() {
    }

    public static void render(String content, Integer width, Integer height, OutputStream stream) {
        new QrCode(content, (int)width, (int)height).renderToOutputStream(stream);
    }

    public static void render120x120(String content, OutputStream stream) {
        QrCodeKit.render(content, 120, 120, stream);
    }

    public static void render140x140(String content, OutputStream stream) {
        QrCodeKit.render(content, 140, 140, stream);
    }

    static class QrCode {
        private String content;
        private int width;
        private int height;
        private ErrorCorrectionLevel errorCorrectionLevel;

        private QrCode(String content, int width, int height) {
            this.init(content, width, height, null);
        }

        private QrCode(String content, int width, int height, ErrorCorrectionLevel errorCorrectionLevel) {
            this.init(content, width, height, errorCorrectionLevel);
        }

        private QrCode(String content, int width, int height, char errorCorrectionLevel) {
            this.init(content, width, height, errorCorrectionLevel);
        }

        private void init(String content, int width, int height, char errorCorrectionLevel) {
            if (errorCorrectionLevel == 'H') {
                this.init(content, width, height, ErrorCorrectionLevel.H);
            } else if (errorCorrectionLevel == 'Q') {
                this.init(content, width, height, ErrorCorrectionLevel.Q);
            } else if (errorCorrectionLevel == 'M') {
                this.init(content, width, height, ErrorCorrectionLevel.M);
            } else if (errorCorrectionLevel == 'L') {
                this.init(content, width, height, ErrorCorrectionLevel.L);
            } else {
                throw new IllegalArgumentException("errorCorrectionLevel \u7ea0\u9519\u7ea7\u522b\u53c2\u6570\u503c\uff0c\u4ece\u9ad8\u5230\u4f4e\u5fc5\u987b\u4e3a\uff1a 'H'\u3001'Q'\u3001'M'\u3001'L'");
            }
        }

        private void init(String content, int width, int height, ErrorCorrectionLevel errorCorrectionLevel) {
            if (StrKit.isBlank(content)) {
                throw new IllegalArgumentException("content \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (width < 0 || height < 0) {
                throw new IllegalArgumentException("width \u4e0e height \u4e0d\u80fd\u5c0f\u4e8e 0");
            }
            this.content = content;
            this.width = width;
            this.height = height;
            this.errorCorrectionLevel = errorCorrectionLevel;
        }

        private void renderToOutputStream(OutputStream stream) {
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            hints.put(EncodeHintType.MARGIN, 0);
            if (this.errorCorrectionLevel != null) {
                hints.put(EncodeHintType.ERROR_CORRECTION, this.errorCorrectionLevel);
            }
            QRCodeWriter writer = new QRCodeWriter();
            try {
                BitMatrix bitMatrix = writer.encode(this.content, BarcodeFormat.QR_CODE, this.width, this.height, hints);
                MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)stream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

