/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.date;

import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class DateTimeKit {
    public static final String FULL_DATE_24HR_STYLE = "yyyy-MM-dd HH:mm:ss";
    public static final String FULL_DATE_12HR_STYLE = "yyyy-MM-dd hh:mm:ss";
    public static final String DATE_TIME_24HR_STYLE = "yyyy-MM-dd HH:mm";
    public static final String DATE_TIME_12HR_STYLE = "yyyy-MM-dd hh:mm";
    public static final String DATE_STYLE = "yyyy-MM-dd";
    public static final String TIME_24HR_STYLE = "HH:mm";
    public static final String TIME_12HR_STYLE = "hh:mm";
    private static Calendar cal = Calendar.getInstance();

    private DateTimeKit() {
    }

    private static String formatDateToFULLHRStyle(HR hr, String spacer, Date date) {
        if (null == date) {
            return "";
        }
        if (null == spacer) {
            spacer = "-";
        }
        String hh = "HH";
        if (hr == HR.HR12) {
            hh = "hh";
        }
        return new SimpleDateFormat("yyyy" + spacer + "MM" + spacer + "dd " + hh + ":mm:ss").format(date);
    }

    private static void setTime() {
        cal.setTime(DateTimeKit.now());
    }

    private static Date now() {
        return new Date();
    }

    public static int year() {
        DateTimeKit.setTime();
        return cal.get(1);
    }

    public static int month() {
        DateTimeKit.setTime();
        return cal.get(2) + 1;
    }

    public static int dayOfMonth() {
        DateTimeKit.setTime();
        return cal.get(5);
    }

    public static int dayOfYear() {
        DateTimeKit.setTime();
        return cal.get(6);
    }

    public static int dayOfWeek() {
        DateTimeKit.setTime();
        int dayofweek = cal.get(7) - 1;
        if (dayofweek == 0) {
            dayofweek = 7;
        }
        return dayofweek;
    }

    public static String formatDate(int style, Date date) {
        if (date == null) {
            return "";
        }
        if (style < 0) {
            style = 2;
        }
        return DateFormat.getDateInstance(style).format(date);
    }

    public static String formatNow(int style) {
        return DateTimeKit.formatDate(style, DateTimeKit.now());
    }

    public static String formatDateToFull(Date date) {
        return DateTimeKit.formatDate(0, date);
    }

    public static String formatNowToFull() {
        return DateTimeKit.formatNow(0);
    }

    public static String formatDateToMedium(Date date) {
        return DateTimeKit.formatDate(2, date);
    }

    public static String formatNowToMedium() {
        return DateTimeKit.formatNow(2);
    }

    public static String formatDateToShort(Date date) {
        return DateTimeKit.formatDate(3, date);
    }

    public static String formatNowToShort() {
        return DateTimeKit.formatNow(3);
    }

    public static String formatDateToStyle(String style, Date date) {
        if (null == date) {
            return "";
        }
        if (null == style) {
            style = FULL_DATE_24HR_STYLE;
        }
        return new SimpleDateFormat(style).format(date);
    }

    public static String formatNowToStyle(String style) {
        return DateTimeKit.formatDateToStyle(style, DateTimeKit.now());
    }

    public static String formatDateToFULL24HRStyle(String spacer, Date date) {
        return DateTimeKit.formatDateToFULLHRStyle(HR.HR24, spacer, date);
    }

    public static String formatNowToFULL24HRStyle(String spacer) {
        return DateTimeKit.formatDateToFULL24HRStyle(spacer, DateTimeKit.now());
    }

    public static String formatDateToFULL12HRStyle(String spacer, Date date) {
        return DateTimeKit.formatDateToFULLHRStyle(HR.HR12, spacer, date);
    }

    public static String formatNowToFULL12HRStyle(String spacer) {
        return DateTimeKit.formatDateToFULL12HRStyle(spacer, DateTimeKit.now());
    }

    public static String formatDateToHRStyle(HR hr, Date date) {
        if (null == date) {
            return "";
        }
        String style = TIME_24HR_STYLE;
        if (hr == HR.HR12) {
            style = TIME_12HR_STYLE;
        }
        return DateTimeKit.formatDateToStyle(style, date);
    }

    public static String formatNowToHRStyle(HR hr) {
        return DateTimeKit.formatDateToHRStyle(hr, DateTimeKit.now());
    }

    public static String formatUnixTime(String style, BigInteger unixtime) {
        SimpleDateFormat sdf = new SimpleDateFormat(style);
        return sdf.format(unixtime);
    }

    public static String formatUnixTimeToShort24HRStyle(BigInteger unixtime) {
        return DateTimeKit.formatUnixTime(DATE_TIME_24HR_STYLE, unixtime);
    }

    public static String formatUnixTimeTo24HRStyle(BigInteger unixtime) {
        return DateTimeKit.formatUnixTime(FULL_DATE_24HR_STYLE, unixtime);
    }

    public static String formatUnixTimeToShort12HRStyle(BigInteger unixtime) {
        return DateTimeKit.formatUnixTime(DATE_TIME_12HR_STYLE, unixtime);
    }

    public static String formatUnixTimeTo12HRStyle(BigInteger unixtime) {
        return DateTimeKit.formatUnixTime(FULL_DATE_12HR_STYLE, unixtime);
    }

    public static Date dateStringToDate(String dateString) {
        SimpleDateFormat sdf = new SimpleDateFormat(FULL_DATE_24HR_STYLE);
        Date date = null;
        try {
            date = sdf.parse(dateString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static Date formatUnixTimeToDate(BigInteger unixtime) {
        return DateTimeKit.dateStringToDate(DateTimeKit.formatUnixTime(FULL_DATE_24HR_STYLE, unixtime));
    }

    public static Long getMonth1stDay() {
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.set(5, 1);
        return cal.getTimeInMillis();
    }

    public static Long getMonthLastDay() {
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.set(5, 1);
        cal.roll(5, -1);
        return cal.getTimeInMillis();
    }

    public static Long getMonday() {
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.add(5, -DateTimeKit.dayOfWeek() + 1);
        return cal.getTimeInMillis();
    }

    public static Long getSunday() {
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.add(5, -DateTimeKit.dayOfWeek() + 7);
        return cal.getTimeInMillis();
    }

    public static Long getUnixTimeAfterDay(int day) {
        return (long)(day * 24 * 60) * 60L + System.currentTimeMillis() / 1000L;
    }

    public static Long getUnixTimeBeforeDay(int day) {
        return System.currentTimeMillis() / 1000L - (long)(day * 24 * 60) * 60L;
    }

    public static Long getCurrentUnixTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static BigInteger getUnixTimeMillis(BigInteger time) {
        return time.multiply(new BigInteger("1000"));
    }

    public static BigInteger getUnixTimeMillis(Long time) {
        return new BigInteger(String.valueOf(time * 1000L));
    }

    private static enum HR {
        HR24,
        HR12;

    }
}

