/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.platform;

import eu.bitwalker.useragentutils.DeviceType;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.UserAgent;
import javax.servlet.http.HttpServletRequest;

public final class PlatformKit {
    private PlatformKit() {
    }

    private static OperatingSystem getOs(HttpServletRequest request) {
        return UserAgent.parseUserAgentString((String)request.getHeader("User-Agent")).getOperatingSystem();
    }

    private static DeviceType getDeviceType(HttpServletRequest request) {
        return PlatformKit.getOs(request).getDeviceType();
    }

    public static boolean isWeb(HttpServletRequest request) {
        return PlatformKit.getDeviceType(request).equals((Object)DeviceType.COMPUTER) || PlatformKit.getDeviceType(request).equals((Object)DeviceType.UNKNOWN);
    }

    public static boolean isMobile(HttpServletRequest request) {
        return PlatformKit.getDeviceType(request).equals((Object)DeviceType.MOBILE);
    }

    public static boolean isAndroid(HttpServletRequest request) {
        return OperatingSystem.ANDROID.equals((Object)PlatformKit.getOs(request));
    }

    public static boolean isIOS(HttpServletRequest request) {
        return OperatingSystem.IOS.equals((Object)PlatformKit.getOs(request));
    }
}

