/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.validate;

import org.openingo.jdkits.validate.ValidateKit;

public final class AssertKit {
    private AssertKit() {
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isFalse(boolean expression, String message) {
        if (expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isNull(Object object, String message) {
        if (ValidateKit.isNotNull(object)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object object, String message) {
        if (ValidateKit.isNull(object)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isEmpty(Object[] array, String message) {
        if (ValidateKit.isNotEmpty(array)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array, String message) {
        if (ValidateKit.isEmpty(array)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isEqual(Object a, Object b, String message) {
        if (ValidateKit.isNotEqual(a, b)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isNotEqual(Object a, Object b, String message) {
        if (ValidateKit.isEqual(a, b)) {
            throw new IllegalArgumentException(message);
        }
    }
}

