/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.openingo.jdkits.stream.StreamKit;
import org.openingo.jdkits.validate.AssertKit;

public final class FileCopyKit {
    public static final int BUFFER_SIZE = 4096;

    private FileCopyKit() {
    }

    public static int copy(File in, File out) throws IOException {
        AssertKit.notNull(in, "No input File specified");
        AssertKit.notNull(out, "No output File specified");
        return FileCopyKit.copy(Files.newInputStream(in.toPath(), new OpenOption[0]), Files.newOutputStream(out.toPath(), new OpenOption[0]));
    }

    public static void copy(byte[] in, File out) throws IOException {
        AssertKit.notNull(in, "No input byte array specified");
        AssertKit.notNull(out, "No output File specified");
        FileCopyKit.copy(new ByteArrayInputStream(in), Files.newOutputStream(out.toPath(), new OpenOption[0]));
    }

    public static byte[] copyToByteArray(File in) throws IOException {
        AssertKit.notNull(in, "No input File specified");
        return FileCopyKit.copyToByteArray(Files.newInputStream(in.toPath(), new OpenOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        AssertKit.notNull(in, "No InputStream specified");
        AssertKit.notNull(out, "No OutputStream specified");
        try {
            int n = StreamKit.copy(in, out);
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        AssertKit.notNull(in, "No input byte array specified");
        AssertKit.notNull(out, "No OutputStream specified");
        try {
            out.write(in);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] copyToByteArray(InputStream in) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        FileCopyKit.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader in, Writer out) throws IOException {
        AssertKit.notNull(in, "No Reader specified");
        AssertKit.notNull(out, "No Writer specified");
        try {
            int byteCount = 0;
            char[] buffer = new char[4096];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(String in, Writer out) throws IOException {
        AssertKit.notNull(in, "No input String specified");
        AssertKit.notNull(out, "No Writer specified");
        try {
            out.write(in);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String copyToString(Reader in) throws IOException {
        if (in == null) {
            return "";
        }
        StringWriter out = new StringWriter();
        FileCopyKit.copy(in, (Writer)out);
        return out.toString();
    }
}

