/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.validate;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public final class ValidateKit {
    private ValidateKit() {
    }

    public static boolean isNull(Object obj) {
        return ValidateKit.isEmpty(obj);
    }

    public static boolean isNotNull(Object obj) {
        return !ValidateKit.isNull(obj);
    }

    public static boolean isContainNull(Object ... objs) {
        if (null == objs) {
            return true;
        }
        for (Object obj : objs) {
            if (!ValidateKit.isEmpty(obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNull(Object ... objs) {
        if (null == objs) {
            return true;
        }
        for (Object obj : objs) {
            if (!ValidateKit.isNotEmpty(obj)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNotNull(Object ... objs) {
        return !ValidateKit.isContainNull(objs);
    }

    public static boolean isEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        return false;
    }

    public static boolean isNotEmpty(Object obj) {
        return !ValidateKit.isEmpty(obj);
    }

    public static boolean isEqual(Object a, Object b) {
        return a == b || (ValidateKit.isNotNull(a) ? a.equals(b) : !ValidateKit.isNotNull(b) || b.equals(a));
    }

    public static boolean isNotEqual(Object a, Object b) {
        return ValidateKit.isNotNull(a) ? !a.equals(b) : (ValidateKit.isNotNull(b) ? !b.equals(a) : false);
    }

    public static boolean isTrue(Boolean bool) {
        return ValidateKit.isNotNull(bool) && bool != false;
    }

    public static boolean isFalse(Boolean bool) {
        return !ValidateKit.isTrue(bool);
    }
}

