/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.tree;

import java.util.Comparator;
import java.util.List;
import org.openingo.jdkits.collection.ListKit;
import org.openingo.jdkits.lang.StrKit;
import org.openingo.jdkits.tree.ITreeNode;
import org.openingo.jdkits.validate.AssertKit;
import org.openingo.jdkits.validate.ValidateKit;

public final class TreeBuilder {
    private TreeBuilder() {
    }

    public static <E extends ITreeNode<E>> List<E> buildTree(String nonNullRootNodeId, List<E> entityList) {
        return TreeBuilder.buildTree(nonNullRootNodeId, entityList, true, null);
    }

    public static <E extends ITreeNode<E>> List<E> buildTree(String nonNullRootNodeId, List<E> entityList, Comparator<? super E> comparator) {
        return TreeBuilder.buildTree(nonNullRootNodeId, entityList, true, comparator);
    }

    public static <E extends ITreeNode<E>> List<E> buildTree(String nonNullRootNodeId, List<E> entityList, boolean hasRoot) {
        return TreeBuilder.buildTree(nonNullRootNodeId, entityList, hasRoot, null);
    }

    public static <E extends ITreeNode<E>> List<E> buildTree(String nonNullRootNodeId, List<E> entityList, boolean hasRoot, Comparator<? super E> comparator) {
        AssertKit.isFalse(ValidateKit.isNull(nonNullRootNodeId) || StrKit.equalsAny(nonNullRootNodeId, "0", "null"), "nonNullRootNodeId cannot be null or 0 or \"null\".");
        return TreeBuilder.toTree(nonNullRootNodeId, entityList, hasRoot, comparator);
    }

    public static <E extends ITreeNode<E>> List<E> buildTree(RootNode rootNode, List<E> entityList) {
        return TreeBuilder.toTree(rootNode.id, entityList, true, null);
    }

    public static <E extends ITreeNode<E>> List<E> buildTree(RootNode rootNode, List<E> entityList, Comparator<? super E> comparator) {
        return TreeBuilder.toTree(rootNode.id, entityList, true, comparator);
    }

    private static <E extends ITreeNode<E>> List<E> toTree(String rootNodeId, List<E> entities, boolean hasRoot, Comparator<? super E> comparator) {
        List<ITreeNode> retTree = ListKit.emptyArrayList();
        if (StrKit.isBlank(rootNodeId)) {
            entities.stream().filter(entity -> StrKit.isBlank(entity.treeRootNodeId())).forEach(retTree::add);
        } else if (StrKit.equalsAny(rootNodeId, "0", "null")) {
            entities.stream().filter(entity -> rootNodeId.equals(entity.treeRootNodeId())).forEach(retTree::add);
        } else if (hasRoot) {
            entities.stream().filter(entity -> rootNodeId.equals(entity.treeNodeId())).forEach(retTree::add);
        } else {
            entities.stream().filter(entity -> rootNodeId.equals(entity.treeRootNodeId())).forEach(retTree::add);
        }
        if (ValidateKit.isEmpty(retTree)) {
            return retTree;
        }
        if (ValidateKit.isNotNull(comparator)) {
            retTree.sort(comparator);
        }
        retTree.forEach(entity -> entity.putChildNodes(TreeBuilder.getChildNodes(entity.treeNodeId(), entities, comparator)));
        return retTree;
    }

    private static <E extends ITreeNode<E>> List<E> getChildNodes(String nodeParentId, List<E> entityList, Comparator<? super E> comparator) {
        List<ITreeNode> childNodes = ListKit.emptyArrayList();
        entityList.stream().filter(entity -> nodeParentId.equals(entity.treeRootNodeId())).forEach(childNodes::add);
        if (ValidateKit.isNotNull(comparator)) {
            childNodes.sort(comparator);
        }
        childNodes.forEach(entity -> entity.putChildNodes(TreeBuilder.getChildNodes(entity.treeNodeId(), entityList, comparator)));
        return childNodes;
    }

    public static enum RootNode {
        ZERO_ID("0"),
        NULL_ID("null");

        private String id;

        private RootNode(String id) {
            this.id = id;
        }
    }
}

