/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.http;

import java.util.HashMap;
import org.openingo.jdkits.validate.ValidateKit;

public final class RespData
extends HashMap<String, Object> {
    private static final long serialVersionUID = 7348797463704162367L;
    private static final String REQUEST_DATA_INVALID = "request_data_invalid!";
    private static final String RESPONSE_DATA_INVALID = "response_data_invalid!";

    public static RespData invalidReq() {
        return RespData.failure(REQUEST_DATA_INVALID);
    }

    public static RespData invalidResp() {
        return RespData.failure(RESPONSE_DATA_INVALID);
    }

    public static RespData ret(RespData data) {
        if (ValidateKit.isNull(data)) {
            return RespData.invalidResp();
        }
        return data;
    }

    public static RespData success() {
        return new RespData(Config.SUCCESS_SC, Config.SUCCESS_SM);
    }

    public static RespData success(Object data) {
        return new RespData(Config.SUCCESS_SC, Config.SUCCESS_SM, data);
    }

    public static RespData failure(String sm) {
        return new RespData(Config.FAILURE_SC, sm);
    }

    public static RespData failure(Object sc, String sm) {
        return ValidateKit.isNull(sc) ? RespData.failure(sm) : new RespData(sc, sm);
    }

    private RespData() {
    }

    private RespData(Object sc, String sm) {
        if (!Config.SM_ONLY) {
            this.put(Config.SC_KEY, sc);
        }
        this.put(Config.SM_KEY, sm);
    }

    private RespData(Object sc, String sm, Object data) {
        this(sc, sm);
        if (ValidateKit.isNotNull(data)) {
            this.put(Config.DATA_KEY, data);
        }
    }

    public Object getSc() {
        if (Config.SM_ONLY) {
            return Config.UNSET_SC;
        }
        return this.get(Config.SC_KEY).toString();
    }

    public String getSm() {
        return this.get(Config.SM_KEY).toString();
    }

    public <T> T getData() {
        if (!this.containsKey(Config.DATA_KEY)) {
            return null;
        }
        return (T)this.get(Config.DATA_KEY);
    }

    public static final class Config {
        public static String SC_KEY = "sc";
        public static String SM_KEY = "sm";
        public static String DATA_KEY = "data";
        public static Object SUCCESS_SC = "success";
        public static String SUCCESS_SM = "response successful";
        public static Object FAILURE_SC = "failure";
        public static boolean SM_ONLY = false;
        public static final Object UNSET_SC = "unset";
        public static String FRIENDLY_FAILURE_MESSAGE = "The system is temporarily unavailable";
    }
}

