/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.file;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.openingo.jdkits.image.ImageKit;
import org.openingo.jdkits.lang.StrKit;
import org.openingo.jdkits.validate.ValidateKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileKit {
    private static Logger log = LoggerFactory.getLogger(ImageKit.class);

    private FileKit() {
    }

    public static void delete(File file) {
        if (file != null && file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        FileKit.delete(files[i]);
                    }
                }
                file.delete();
            }
        }
    }

    public static String getFileExtension(String fileFullName) {
        if (StrKit.isBlank(fileFullName)) {
            throw new RuntimeException("fileFullName is empty");
        }
        return FileKit.getFileExtension(new File(fileFullName));
    }

    public static String getFileExtension(File file) {
        if (null == file) {
            throw new NullPointerException();
        }
        String fileName = file.getName();
        int dotIdx = fileName.lastIndexOf(46);
        return dotIdx == -1 ? "" : fileName.substring(dotIdx + 1);
    }

    private static String getFileCRCCode(InputStream inputStream) {
        CRC32 crc32 = new CRC32();
        byte[] buffer = null;
        try {
            CheckedInputStream checkedinputstream = new CheckedInputStream(inputStream, crc32);
            buffer = new byte[1024];
            while (checkedinputstream.read(buffer) != -1) {
            }
            inputStream.close();
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return Long.toHexString(crc32.getValue());
    }

    public static String getFileCRCCode(File file) throws Exception {
        FileInputStream inputStream = new FileInputStream(file);
        return FileKit.getFileCRCCode(inputStream);
    }

    public static String getStringCRCCode(String string) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(string.getBytes());
        return FileKit.getFileCRCCode(inputStream);
    }

    public static boolean exists(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    public static boolean isFile(String filePath) {
        File file = new File(filePath);
        return file.isFile();
    }

    public static boolean isDirectory(String filePath) {
        File file = new File(filePath);
        return file.isDirectory();
    }

    public static boolean renameTo(String srcFile, String targetFile) {
        File file = new File(srcFile);
        return file.renameTo(new File(targetFile));
    }

    public static void createDirectories(String path) {
        try {
            String path1;
            StringTokenizer st = new StringTokenizer(path, "/");
            String path2 = path1 = st.nextToken() + "/";
            while (st.hasMoreTokens()) {
                path1 = st.nextToken() + "/";
                File inbox = new File(path2 = path2 + path1);
                if (inbox.exists()) continue;
                inbox.mkdir();
            }
        }
        catch (Exception e) {
            System.out.println("\u76ee\u5f55\u521b\u5efa\u5931\u8d25" + e);
            e.printStackTrace();
        }
    }

    public static boolean deleteDirectory(String dirPath) {
        File[] files;
        if (ValidateKit.isNotNull(dirPath)) {
            return false;
        }
        File path = new File(dirPath);
        if (!path.exists()) {
            return false;
        }
        if (path.isFile()) {
            return path.delete();
        }
        for (File file : files = path.listFiles()) {
            FileKit.deleteDirectory(file.getAbsolutePath());
        }
        return path.delete();
    }

    public static boolean renameDirectory(String srcPath, String targetPath) {
        File srcFile = new File(srcPath);
        File targetFile = new File(targetPath);
        return srcFile.renameTo(targetFile);
    }

    public static boolean makeDirectory(String path) throws Exception {
        File file = new File(path);
        return file.mkdirs();
    }
}

