/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.lang;

import com.esotericsoftware.reflectasm.ConstructorAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.beans.BeanCopier;
import net.sf.cglib.core.Converter;

public final class CgBeanKit {
    private static final Map<String, BeanCopier> BEAN_COPIER_CACHE = new ConcurrentHashMap<String, BeanCopier>();
    private static final Map<String, ConstructorAccess> CONSTRUCTOR_ACCESS_CACHE = new ConcurrentHashMap<String, ConstructorAccess>();

    private CgBeanKit() {
    }

    public static void copyProperties(Object source, Object target) {
        CgBeanKit.copyProperties(source, target, null);
    }

    public static void copyProperties(Object source, Object target, Converter converter) {
        BeanCopier copier = CgBeanKit.getBeanCopier(source.getClass(), target.getClass());
        copier.copy(source, target, converter);
    }

    private static BeanCopier getBeanCopier(Class<?> sourceClass, Class<?> targetClass) {
        String beanKey = CgBeanKit.generateKey(sourceClass, targetClass);
        BeanCopier copier = null;
        if (!BEAN_COPIER_CACHE.containsKey(beanKey)) {
            copier = BeanCopier.create(sourceClass, targetClass, (boolean)false);
            BEAN_COPIER_CACHE.put(beanKey, copier);
        } else {
            copier = BEAN_COPIER_CACHE.get(beanKey);
        }
        return copier;
    }

    private static String generateKey(Class<?> sourceClass, Class<?> targetClass) {
        return sourceClass.getName() + targetClass.getName();
    }

    public static <T> T copyProperties(Object source, Class<T> targetClass) {
        return CgBeanKit.copyProperties(source, targetClass, null);
    }

    public static <T> T copyProperties(Object source, Class<T> targetClass, Converter converter) {
        T t = null;
        try {
            t = targetClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(String.format("Create new instance of %s failed: %s", targetClass, e.getMessage()));
        }
        CgBeanKit.copyProperties(source, t, converter);
        return t;
    }

    public static <T> List<T> copyPropertiesOfList(List<?> sourceList, Class<T> targetClass) {
        return CgBeanKit.copyPropertiesOfList(sourceList, targetClass, null);
    }

    public static <T> List<T> copyPropertiesOfList(List<?> sourceList, Class<T> targetClass, Converter converter) {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ConstructorAccess<T> constructorAccess = CgBeanKit.getConstructorAccess(targetClass);
        ArrayList<Object> resultList = new ArrayList<Object>(sourceList.size());
        for (Object o : sourceList) {
            Object t = null;
            try {
                t = constructorAccess.newInstance();
                CgBeanKit.copyProperties(o, t, converter);
                resultList.add(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return resultList;
    }

    private static <T> ConstructorAccess<T> getConstructorAccess(Class<T> targetClass) {
        ConstructorAccess constructorAccess = CONSTRUCTOR_ACCESS_CACHE.get(targetClass.getName());
        if (constructorAccess != null) {
            return constructorAccess;
        }
        try {
            constructorAccess = ConstructorAccess.get(targetClass);
            constructorAccess.newInstance();
            CONSTRUCTOR_ACCESS_CACHE.put(targetClass.toString(), constructorAccess);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Create new instance of %s failed: %s", targetClass, e.getMessage()));
        }
        return constructorAccess;
    }
}

