/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.lang;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openingo.jdkits.lang.ThreadShare;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadShareKit {
    private static Logger log = LoggerFactory.getLogger(ThreadShareKit.class);
    private static final String DEFAULT_SHARE = "default-thread-share";
    private static final Map<ThreadShare<Object>, Object> MAPPING = new ConcurrentHashMap<ThreadShare<Object>, Object>();

    private ThreadShareKit() {
    }

    private static ThreadShare<Object> getShareByName(String name) {
        return new ThreadShare<Object>(name);
    }

    public static <T> void put(T data) {
        ThreadShareKit.put(DEFAULT_SHARE, data);
    }

    public static <T> T get() {
        return ThreadShareKit.get(DEFAULT_SHARE);
    }

    public static <T> T getRemove() {
        return ThreadShareKit.getRemove(DEFAULT_SHARE);
    }

    public static <T> void put(String name, T data) {
        log.info("put data with name {} data {}", (Object)name, data);
        MAPPING.put(ThreadShareKit.getShareByName(name), data);
    }

    public static <T> T get(String name) {
        ThreadShare<Object> share = ThreadShareKit.getShareByName(name);
        if (!MAPPING.containsKey(share)) {
            log.info("name {} is not exist", (Object)name);
            return null;
        }
        Object data = MAPPING.get(share);
        log.info("get data {} with name {}", data, (Object)name);
        return (T)data;
    }

    public static <T> T getRemove(String name) {
        ThreadShare<Object> share = ThreadShareKit.getShareByName(name);
        if (!MAPPING.containsKey(share)) {
            log.info("name {} is not exist", (Object)name);
            return null;
        }
        Object data = MAPPING.remove(share);
        log.info("getRemove data {} with name {}", data, (Object)name);
        return (T)data;
    }
}

