/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.sys;

import java.util.Collection;
import java.util.Map;
import org.openingo.jdkits.validate.ValidateKit;

public final class SysOutPrintKit {
    private SysOutPrintKit() {
    }

    @SafeVarargs
    public static <T> void print(String format, T ... args) {
        System.out.print(String.format(format, args));
    }

    @SafeVarargs
    public static <T> void println(String format, T ... args) {
        System.out.println(String.format(format, args));
    }

    public static void printArray(Object[] array) {
        if (ValidateKit.isNull(array)) {
            return;
        }
        StringBuilder formatBuilder = new StringBuilder("len:%s, data=[");
        int len = array.length;
        String[] values = new String[len + 1];
        values[0] = String.valueOf(len);
        for (int i = 0; i < len; ++i) {
            formatBuilder.append("%s");
            values[i + 1] = array[i].toString();
            if (i == len - 1) continue;
            formatBuilder.append(", ");
        }
        formatBuilder.append("]");
        SysOutPrintKit.println(formatBuilder.toString(), values);
    }

    public static void printList(Collection<?> collection) {
        if (ValidateKit.isNull(collection)) {
            return;
        }
        SysOutPrintKit.println("len:%s, data=" + collection.toString(), collection.size());
    }

    public static void printMapKeys(Map<?, ?> map) {
        if (ValidateKit.isNull(map)) {
            SysOutPrintKit.println("Map ==> null.", new Object[0]);
            return;
        }
        SysOutPrintKit.printList(map.keySet());
    }

    public static void printMapValues(Map<?, ?> map) {
        if (ValidateKit.isNull(map)) {
            SysOutPrintKit.println("Map ==> null.", new Object[0]);
            return;
        }
        SysOutPrintKit.printList(map.values());
    }

    public static void printMap(Map<?, ?> map) {
        if (ValidateKit.isNull(map)) {
            SysOutPrintKit.println("Map ==> null.", new Object[0]);
            return;
        }
        SysOutPrintKit.print("Map-Keys ==> ", new Object[0]);
        SysOutPrintKit.printMapKeys(map);
        SysOutPrintKit.print("Map-Values ==> ", new Object[0]);
        SysOutPrintKit.printMapValues(map);
        SysOutPrintKit.print("Map ==> ", new Object[0]);
        System.out.println(map);
    }
}

