/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.file;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.sl.extractor.SlideShowExtractor;
import org.apache.poi.sl.usermodel.Slide;
import org.apache.poi.sl.usermodel.SlideShow;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.openingo.jdkits.validate.ValidateKit;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlide;

public final class OfficeKit {
    public static String readDoc(InputStream in) throws IOException {
        return OfficeKit.readDoc(in, true);
    }

    public static String readDoc(InputStream in, boolean replaceR) throws IOException {
        String content = "";
        HWPFDocument doc = new HWPFDocument(in);
        if (ValidateKit.isNotNull(doc) && ValidateKit.isNotEmpty(content = doc.getText().toString().trim()) && replaceR) {
            content = content.replaceAll("\r", "\n");
        }
        return content;
    }

    public static String readDocX(InputStream in) throws Exception {
        XWPFWordExtractor extractor = new XWPFWordExtractor(new XWPFDocument(in));
        return extractor.getText();
    }

    public static String readPowerPoint(InputStream in) throws IOException {
        StringBuilder content = new StringBuilder();
        HSLFSlideShow hslfSlideShow = new HSLFSlideShow(in);
        List slides = hslfSlideShow.getSlides();
        SlideShowExtractor slideShowExtractor = new SlideShowExtractor((SlideShow)hslfSlideShow);
        for (HSLFSlide slide : slides) {
            content.append(slideShowExtractor.getText((Slide)slide));
        }
        slideShowExtractor.close();
        return content.toString();
    }

    public static String readPowerPointX(InputStream in) throws IOException {
        StringBuilder content = new StringBuilder();
        XMLSlideShow xmlSlideShow = new XMLSlideShow(in);
        List slides = xmlSlideShow.getSlides();
        for (XSLFSlide slide : slides) {
            CTSlide rawSlide = slide.getXmlObject();
            CTGroupShape spTree = rawSlide.getCSld().getSpTree();
            List spList = spTree.getSpList();
            for (CTShape shape : spList) {
                CTTextBody txBody = shape.getTxBody();
                if (null == txBody) continue;
                List pList = txBody.getPList();
                for (CTTextParagraph textParagraph : pList) {
                    List textRuns = textParagraph.getRList();
                    for (CTRegularTextRun textRun : textRuns) {
                        content.append(textRun.getT());
                    }
                }
            }
        }
        xmlSlideShow.close();
        return content.toString();
    }

    public static String readXls(InputStream in) throws IOException {
        StringBuilder content = new StringBuilder();
        HSSFWorkbook excel = new HSSFWorkbook(in);
        HSSFSheet sheet0 = excel.getSheetAt(0);
        for (Row cells : sheet0) {
            HSSFRow row = (HSSFRow)cells;
            Iterator iterator = row.cellIterator();
            while (iterator.hasNext()) {
                HSSFCell cell = (HSSFCell)iterator.next();
                if (cell.getCellType() == CellType.STRING) {
                    content.append(cell.getStringCellValue()).append("\t");
                    continue;
                }
                if (cell.getCellType() == CellType.NUMERIC || cell.getCellType() == CellType.FORMULA) {
                    content.append(cell.getNumericCellValue()).append("\t");
                    continue;
                }
                content.append("\t");
            }
        }
        return content.toString();
    }

    public static String readXlsx(InputStream in) throws IOException {
        StringBuilder content = new StringBuilder();
        XSSFWorkbook excel = new XSSFWorkbook(in);
        XSSFSheet sheet0 = excel.getSheetAt(0);
        for (Row cells : sheet0) {
            XSSFRow row = (XSSFRow)cells;
            Iterator iterator = row.cellIterator();
            while (iterator.hasNext()) {
                XSSFCell cell = (XSSFCell)iterator.next();
                if (cell.getCellType() == CellType.STRING) {
                    content.append(cell.getStringCellValue()).append("\t");
                    continue;
                }
                if (cell.getCellType() == CellType.NUMERIC || cell.getCellType() == CellType.FORMULA) {
                    content.append(cell.getNumericCellValue()).append("\t");
                    continue;
                }
                content.append("\t");
            }
        }
        return content.toString();
    }
}

